<?php
/** 
* 
* Manage_bots 5.5
* This script adds, deletes, deactivates or lists multiple bots to your database 
* $Id: add_bots.php raimon $ 
* Updated by Pony99CA
* Installation and execution:
*  1.  Save the entire contents of this script on your PC and name it manage_bots.php (for simplicity)
*  2.  [RECOMMENDED] Set the $admin variable in the CONFIGURATION SECTION to your board's Founder user name if you don't want other admins to run this script
*  3.  [OPTIONAL] Change the $default_operation variable in the CONFIGURATION SECTION to reflect the operation you want performed on the bots
*  4.  [OPTIONAL] Change the $default_level variable in the CONFIGURATION SECTION to reflect the type of bots you want managed
*  5.  [OPTIONAL] Translate the strings in the $mbots_lang array in the CONFIGURATION SECTION to your local language
*  6.  Upload the file to your board's root directory on your Web host (where you find config.php)
*  7.  Log in with your Founder name (or whatever name you set $admin to)
*  8.  Back up your phpBB database (at least the Bots and Users tables) in case something goes wrong
*  9.  Call the script with your Web browser (enter it in your browser's address bar); for example:  http://www.example.com/phpBB3/manage_bots.php
*      By default, that adds bots that people have reported visiting their board.
*      To see the various other operations supported, run the following help command:  http://www.example.com/hhpBB3/manage_bots.php?? (Note the two question marks)
*      NOTE:  The following uses the standard English commands and parameters.  Translated versions of this script may be different.
*             Run the help command listed above to see translated versions.
*      SYNTAX (items in [brackets] are optional; do not type the brackets, but do replace items after the equal signs)
*      TO ADD BOTS TO YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php[?[operation=add&]level=n[&listall=1][&password=admin_pw]]
*        http://www.example.com/phpBB3/manage_bots.php[?[operation=add&]password=admin_pw]
*        http://www.example.com/phpBB3/manage_bots.php[?[operation=add&]listall=1]
*        -- operation=add:  If you changed the $default_operation variable, you should specify this
*        -- level=n: Add bots whose level <= n (if n=0, only the default phpBB bots will be added)
*        -- listall=1: List all bots attempted to be added instead of just ones not in the database
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO DELETE BOTS FROM YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php?operation=delete[&level=n][&password=admin_pw]
*        -- level=n: Delete bots whose level >= n (if n=0, all bots will be deleted)
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO DEACTIVATE BOTS IN YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php?operation=deactivate[&level=n][&password=admin_pw]
*        -- level=n: Deactivate bots whose level >= n (if n=0, all bots will be deactivated)
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO ACTIVATE BOTS IN YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php?operation=activate[&level=n][&password=admin_pw]
*        -- level=n: Activate bots whose level >= n (if n=0, all bots will be activated)
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO LIST BOTS IN YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php?operation=list[&level=n][&listall=1][&format=1][&password=admin_pw]
*        -- level=n: List bots using level = n (for visiting bots) or n+50 in the listing
*        -- listall=1: List all bots in the database instead of just ones not in this script
*        -- format=1: List bots in a tabular format for readability (not recommended for submitting bots to me)
*        -- number=1: Number the rows in the list output (not recommended for submitting bots to me)
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO UPDATE BOTS ALREADY IN YOUR DATABASE WITH NEWER INFORMATION:
*        http://www.example.com/phpBB3/manage_bots.php?operation=update[&password=admin_pw]
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO DISPLAY POTENTIAL BOT CONFLICTS IN YOUR DATABASE:
*        http://www.example.com/phpBB3/manage_bots.php?operation=conflicts[&password=admin_pw]
*        -- password=admin_pw: Required admin password if you set the $admin variable
*      TO DISPLAY HELP FOR THIS SCRIPT:
*        http://www.example.com/phpBB3/manage_bots.php?help
*        http://www.example.com/phpBB3/manage_bots.php??
* 10.  [OPTIONAL] After the script is done, you can delete the file from your Web host. 
*
* NOTE:  You many want to delete the script if you're using a shared PC and haven't set the $admin variable.
*        If you leave it on your host, anybody could delete your bots!
* 
* History:
* 1.0:     Original script by Raimon
* 2.0:     Update by Pony99CA
*          * Fixed the problem with crashing trying to add bots that were already there
*          * Alphabetized the bot list to make it easier to determine if a bot is already in the list
*          * Output status messages showing which bots were and were not added
*          * Output final count of bots added                       
*          * Added installation instructions as comments at the top of the code
*          * Removed redundant code checking for the bot group
*          * Indented and commented the code
* 2.1:     Update by Pony99CA
*          * Added phpBB pre-installed bots to recover them in case of accidental deletion
* 3.0:     Update by Pony99CA
*          * Added new bots from YoungJediKnight
*          * Added bot levels to control which bots were inserted
*          * Rearranged some code to be more efficient when a bot was already in the list
* 3.1:     Update by Pony99CA
*          * Added an admin log message
*          * Allowed specifying the level on the command line
* 3.2:     Update by Pony99CA
*          * Added handler for updated bots
*          * Changed bot level 3 to 52 for future consistency
*          * Updated some bot names to use canonical form with [Bot] tag
*          * Removed a couple of duplicate bots
*          * Used board's bot colour
*          * Fixed bug where bots were not being deleted from User Group table (delete_bots 1.2)
*          * Only list bots that aren't already in the add_bots script by default (list_bots 1.2)
*          * Allowed specifying whether you want all bots listed on the command line (list_bots 1.2)
*          * Output level + 50 for inactive bots (list_bots 1.2)
* 3.2.01:  Update by Pony99CA
*          * Added DailyPerfect bot
* 3.2.02:  Update by Pony99CA
*          * Added Apple Syndication, Karlsruhe and Seznam Screenshot bots
*          * Removed duplicate Apple PubSub bot
* 3.3:     Update by Pony99CA
*          * Changed remove_bot function to use phpBB user_delete function
* 3.3.01:  Update by Pony99CA
*          * Added Conpilot bot
*          * Removed duplicate CCBot (Yeti) bot
* 3.3.02:  Update by Pony99CA
*          * Added Amazon grvcrawler bot
* 4.0:     Update by Pony99CA
*          * Combined add_bots, delete_bots and list_bots into one manage_bots script
*          * Added the update operation to just invoke the update_bots function
*          * Moved fix_bots script function into update_bots just in case somebody didn't run it
*          * Added password support to prevent unauthorized users from running the script
*          * Added warning if conflicting agent strings or IP addresses are found
*          * Cleared the bot cache so results take effect immediately (I hope)
*          * Fixed bug in updating if new bot name already existed
*          * Moved checks to see if the bot was in the user table to the bot_defined function
*          * Used clean username for add and delete comparisons to avoid collisions
*          * Changed default level to 50 to get all visiting bots
*          * Added Bintellibot and Okidoki bots
*          * Removed duplicate GoogleAds, ICjobs, Searchles, SnapPreview, W3C Link Checker and W3C Semantic Data Extractor bots (duplicate agents)
*          * Renamed Google Python URL fetcher [Bot] to Python URL fetcher [Bot] (it's part of Python, not from Google)
*          * Improved the documentation comments
* 4.0.01:  Update by Pony99CA
*          * Added the Begun bot
*          * Changed the Proximic bot to Level 2 as it has now been seen
* 4.1:     Update by Pony99CA
*          * Moved the password check to be the first parameter checked
*          * Added The Best Links bot
* 4.1.01:  Update by Pony99CA
*          * Added iScraper bot
*          * Added Linguee Multi-Lingual bot
*          * Added SEOprofiler bot
*          * Added SimplePie bot
*          * Added Web2PDF converter
*          * Added Yahoo Japan bot
*          * Removed SimilarPages Nutch bot (duplicate)
* 4.1.02:  Update by Pony99CA
*          * Added Cityreview bot
* 4.1.03:  Update by Pony99CA
*          * Added NetSeer bot
*          * Added SuperFeedr bot
* 4.1.04:  Update by Pony99CA
*          * Removed WillyFogg bot (duplicate)
* 4.2:     Update by Pony99CA on December 28, 2010
*          * Changed spaces in IP addresses to null strings
*          * Updated existing bots to remove spaces
*          * Fixed use of wrong (and uninitialized) result variable
*          * Added new default phpBB bot Bing
*          * Added Bit.ly, Gais, Google AppEngine, JS-Kit, KindSight, LongURL, MirarSearch, OWS, PostRank, PycURL, Search.ch, Twenga, Twitmatic, Twitter and Yigg bots
*          * Added Accelobot, eSobi, IIT Bombay, Internet Archive, Luzaki, L.webis, Netvibes, Search 17, Sharegloo, Synthesio bots
*          * Renamed Galik [Bot] to Garlik [Bot] (thanks, AmigoJack)
* 5.0:     Update by Pony99CA on March 12, 2011
*          * Updated to only allow board administrators with manage bots permission to run this script
*          * Added Activate and Deactivate commands
*          * Added ability to set bot's active status and last visit timestamp.  Combined with the List enhancements below, you can now use Delete without losing your Bot visit data.
*          * Added ability to set bot's E-mail address and Web site (based on an idea by AmigoJack)
*          * Updated List command to dump bots' new fields listed above (doing a List before a Delete allows restoring that data after the delete)
*          * Fixed bug which kept saying bugs were updated that were already updated
*          * Fixed all agents to have null strings (some were missed in last update which could lead to problems until you ran the script again)
*          * Added Ezooms bot from Pony99CA
*          * Added numerous bots from AmigoJack
*          * Added several bots from heredia21
*          * Added OrangeAsk and CMS Worldmap bots from TheSnake
*          * Added LinkedIn bot from natalia26
*          * Updated Yigg IP addresses (thanks, AmigoJack)
*          * Updated Snappy user agent
* 5.1:     Update by Pony99CA on March 30, 2011
*          * Changed update_bots to allow updating activation status and last visit
*          * Added GeoHasher bot from roBBx
*          * Combined Exabot and Exalead; added URL
*          * Combined goo and ichiro; renamed and added URL
*          * Updated Snappy's URL
*          * Updated comments showing how to run manage_bots for clarity
* 5.2:     Update by Pony99CA on August 28, 2011
*          * Added Listall option to Add operation; default is now to minimize output
*          * Fixed bug where default operation would not get options processed unless the Operation option was specified
*          * Added Dow Jones Searchbot from Puchahawa
*          * Added Alkaline bot from T50 (from the old Bots Install MOD <http://www.phpbb.com/customise/db/mod/bots_install_script>
*          * Added Radian6 Primer bot from roBBx
*          * Added seven bots from AmigoJack
*          * Added Trendiction bot from Marcus Wendel
*          * Updated E-mail and Web addresses for Radian6 and DiscoveryEngine bots
*          * Update user agent, E-mail and Web address for Garlik
*          * Added page header and footer HTML to show a title (the page won't validate, though)
*          * Updated installation comments for clarity
*          * Moved non-debugging strings into array in customization section suitable for translation and MODding
*          * Added $debug_level to output debugging strings instead of commenting them out 
*          * Added Debug option to control $debug_level from the command line
* 5.3:     Update by Pony99CA on September 19, 2011
*          * Added new command to check for conflicting bots
*          * Added optional formatting for List output and added format and number options
*          * Added four phpBB.com visiting bots and renumbered bot list NOTE: Do not assume that your level number is the same; most were increased by one!
*          * Added TinEye and YandexImages bots
*          * Combined Boitho and Boitho-dc (Boitho seems to have been superceded) and updated Boitho-dc's user agent and URL
*          * Updated CheckLnks name, user agent, E-mail address and URL
*          * Removed DomainTools as duplicate of SurveyBot and updated SurveyBot's name and user agent
*          * Removed left paren from FeedBurner's URL
*          * Updated JCheckLnks name, E-mail address and URL
*          * Updated Yandex to add E-mail address and URL
*          * Updated Yandex Direct name and user agent and added E-mail address and URL
*          * Removed PicSearch as duplicate of psbot and updated psbot's user agent, E-mail address and URL
*          * Removed SBIder as duplicate of SiteSell and updated SiteSell's URL
*          * Updated Cometrics and Webmeasurement to remove comma from user agent (bad for importing into Excel)
*          * Added Web site to Cometrics
*          * Added command and parameter names to language array to allow translating them
*          * Added checks for maximum values of some parameters
*          * Fixed phpBB session errors caused by outputting HTML before session management started
*          * Fixed debug messages when $_GET[...] parameter wasn't specified (thanks doktornotor and AmigoJack)
* 5.3.01:  Update by Pony99CA on December 12, 2011
*          * Added Yahoo China bot from Peter77sx
*          * Added Lemur bot from Schwpz
*          * Added Aitellu, August, Bemash, ContextWeb, Freenewsmobile, JikeSpider, Linkdex, Lycosa, MergeFlow and Yahoo Pipes bots from Marcus Wendel
*          * Added Ahrefs bot from Vinny
*          * Updated Baidu user agent and added E-mail address and URL (thanks, Joshua203)
*          * Added JS-Kit, PostRank, Tweetmeme, Twitter and TwitterFeed E-mail addresses and/or URLs (thanks, Marcus)
*          * Added Sogou URL
* 5.4:     Update by Pony99CA on April 21, 2012
*          * Added Help (or "?") command to display command help; the "?" works even when not logged in to help you get started
*          * Added donation information to output
*          * Added aiHit, Ceron, Crowsnest, Eqentia, Halloo, Infegy, Korean ISA and SocialSearcher bots from Marcus Wendel
*          * Added SEOkicks and YahooCacheSystem bots from Schwpz
*          * Added Internet Memory bot from Vinny
*          * Added AgHave, FLR Treato, Funnelback, Mail.ru, Nigma, VSW and VSW ERA bots from lanesharon
*          * Added DLE_Spider bot from leschek
*          * Added Acoon and NewzCrawler bots from fac7orx
*          * Updated NetSprint user agent and added E-mail address and URL (thanks, Marcus)
*          * Updated the Convera bot's name to VSW Convera and added E-mail address and URL (thanks, lanesharon)
*          * Added BrandWatch E-mail address and URL
*          * Added Summify E-mail address
* 5.5:     Update by Pony99CA on May 27, 2012
*          * Added list of credits (sorted by bots reported) to help
*          * Added link to latest version in Support help
*          * Added script version number to help
*          * Changed get_parameter function to use request_var for security (thanks, Paul)
*          * Fixed bug where updating bots didn't write out delete summary
*          * Stopped updating bots if help requested
*          * Added AddThis bot from Schwpz
*          * Added Blekkobot bot from Joshua203
*          * Added Moreover and BlogSearch bots from fac7orx
*          * Added BeetleBot bot from leschek
*          * Added BuiBui, EasyBib, Feedreader, LiveJournal, McAfee Expand, Searcharoo, Tribal Fusion, Twikle & WikiDo bots from Marcus Wendel
*          * Updated PaperLi URL (thanks, Marcus)
*          * Updated older bots URLs:  CommonCrawl, Furl, Jyxo, Metadata Labs, Noxtrum, Omgili, Spinn3r, Voila
*          * Removed MLbot as duplicate of Metadata Labs
*/

$mbots_version = '5.5';

// ***** CONFIGURATION SECTION *****
// Change this value to add security to the script; only the specified user may run it (and must supply a password)
$admin = "";

// Change this value as described below; default = 50
// add        -- The highest level of bots to add (add bots whose level <= specified level)
// delete     -- The lowest level of bots to delete (delete bots whose level >= specified level)
// activate   -- The lowest level of bots to activate (activate bots whose level >= specified level)
// deactivate -- The lowest level of bots to deactivate (deactivate bots whose level >= specified level)
// list       -- The level to output for bots listed (if they have accessed the board; otherwise level + 50)
// update     -- No effect; applies to all bots in your database
// conflicts  -- No effect; applies to all bots in your database
// help       -- No effect; applies to all bots in your database
$default_level = 50;
$max_level = -1;

// Change this value to list all bots
// true  -- List only bots on the board that aren't in the bot list below
// false -- List all bots defined on the board
$list_new = true;   // Only list bots not listed in $bots array below (for LIST) or not in the database (for ADD)

// Strings used in the script (for translation purposes)
// NOTE:  Do NOT name the array $lang because the phpBB includes wipe it out!
// NOTE:  If you change the MBOTS_OPERATION_* and MBOTS_PARAMETER_* entries, you have to enter commands in your browser like that, too.
$mbots_lang = array (
	'MBOTS_ACTIVATE_COMPLETE' => "<strong>COMPLETE:  You have activated %1\$d bots out of %2\$d at level %3\$d or greater from the bots list!</strong><br />",
	'MBOTS_ACTIVATED_LOG' => "Activated %1\$d level %2\$d bots",
	'MBOTS_ACTIVATING_BOT' => "<span style='color: green;'>Activating bot <em>%s</em> in bot table</span><br /><br />",
	'MBOTS_ADD_COMPLETE' => "<strong>COMPLETE:  You have added %1\$d new bots out of %2\$d at level %3\$d or less to the bots list!</strong><br />",
	'MBOTS_ADDED_LOG' => "Added %1\$d level %2\$d bots",
	'MBOTS_ADDING_BOT' => "<span style='color: green;'>Adding bot <em>%s</em> to bot table</span><br /><br />",
	'MBOTS_ADDING_BOT_ALREADY_DEFINED' => "<span style='color: blue;'>Bot <em>%s</em> already in user table</span><br /><br />",
  'MBOTS_ADDING_BOT_FAILED' => "<span style='color: red;'>Adding bot <em>%s</em> to user table failed!</span><br /><br />",
	'MBOTS_ADMIN_INCORRECT' => "<strong><span style='color: red;'>You must be logged in as %s to run this script</span><br /><br />",
	'MBOTS_ADMIN_PRIVILEGES_REQUIRED' => "<strong><span style='color: red;'>The user you are logged in as, %s, is not an Administrator with Manage Bots permission</span><br /><br />",
	'MBOTS_AGENT_CONFLICT' => "<span style='color: red;'>Warning: <em>%1\$s</em>'s user agent '%2\$s' conflicts with <em>%3\$s</em>'s agent '%4\$s'!</span><br /><br />",
	'MBOTS_CHECKED' => "<strong>TOTAL BOTS CHECKED:  %d</strong><br />",
	'MBOTS_CONFLICTING_BOTS' => "<span style='color: red;'>Bot conflicts found: %s</span><br /><br />",
	'MBOTS_CREATING_GROUP' => "<strong>Creating missing bot group</strong><br />",
	'MBOTS_DEACTIVATE_COMPLETE' => "<strong>COMPLETE:  You have deactivated %1\$d bots out of %2\$d at level %3\$d or greater from the bots list!</strong><br />",
	'MBOTS_DEACTIVATED_LOG' => "Deactivated %1\$d level %2\$d bots",
	'MBOTS_DEACTIVATING_BOT' => "<span style='color: green;'>Deactivating bot <em>%s</em> in bot table</span><br /><br />",
	'MBOTS_DELETE_COMPLETE' => "<strong>COMPLETE:  You have deleted %1\$d bots out of %2\$d at level %3\$d or greater from the bots list!</strong><br />",
	'MBOTS_DELETED_LOG' => "Deleted %1\$d level %2\$d bots",
	'MBOTS_DELETED_OLD_BOT' => "Deleted obsolete or duplicate bot %s<br />",
	'MBOTS_DELETED_OLD_BOTS' => "<strong>Bots deleted: %d</strong><br />",
	'MBOTS_DELETED_OLD_LOG' => "Deleted %d obsolete or duplicate bots",
	'MBOTS_DELETING_BOT' => "<span style='color: green;'>Deleting bot <em>%s</em> from bot table</span><br /><br />",
	'MBOTS_GROUP_NOT_DEFINED' => "<span style='color: red;'>Bot group not defined.  Exiting....</span><br /><br />",
	'MBOTS_HEADER_BOT_ACTIVE' => "Active?",
	'MBOTS_HEADER_BOT_EMAIL' => "E-mail Address",
	'MBOTS_HEADER_BOT_IP_ADDRESS' => "IP Address(es)",
	'MBOTS_HEADER_BOT_LAST_VISIT' => "Last Visited",
	'MBOTS_HEADER_BOT_LEVEL' => "Level",
	'MBOTS_HEADER_BOT_NAME' => "Name",
	'MBOTS_HEADER_BOT_NUMBER' => "Bot #",
	'MBOTS_HEADER_BOT_REPORTER' => "Reporter",
	'MBOTS_HEADER_BOT_USER_AGENT' => "User Agent",
	'MBOTS_HEADER_BOT_WEB_SITE' => "Web Site URL",
	'MBOTS_HELP_ACTIVATE' => "<p><strong>TO ACTIVATE BOTS IN YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>n</em>][&%4\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>n</em></tt>: Activate bots whose level >= <em>n</em> (if <em>n</em>=0, all bots will be activated)<br />
				&mdash; <tt>%4\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_ADD' => "<p><strong>TO ADD BOTS TO YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php[?[%2\$s=%1\$s&]%3\$s=<em>n</em>[&%4\$s=1][&%5\$s=<em>admin_pw</em>]]</tt><br />
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php[?[%2\$s=%1\$s&]%5\$s=<em>admin_pw</em>]</tt><br />
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php[?[%2\$s=%1\$s&]%4\$s=1]</tt><br /><br />
				&mdash; <tt>%2\$s=%1\$s</tt>:  If you changed the <tt>\$default_operation</tt> variable, you should specify this<br />
				&mdash; <tt>%3\$s=<em>n</em></tt>: Add bots whose level <= <em>n</em> (if <em>n</em>=0, only the default phpBB bots will be added)<br />
				&mdash; <tt>%4\$s=1</tt>: List all bots attempted to be added instead of just ones not in the database<br />
				&mdash; <tt>%5\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_CONFLICTS' => "<p><strong>TO DISPLAY POTENTIAL BOT CONFLICTS IN YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_CREDITS' => "<p><strong>CREDITS:</p><p></strong>Thanks to the following people for reporting new bots and other contributions to this script:</p>",
	'MBOTS_HELP_CREDITS_HEADER_NAME' => "User Name",
	'MBOTS_HELP_CREDITS_HEADER_RANK' => "Rank",
	'MBOTS_HELP_CREDITS_HEADER_VISITING_BOTS' => "Visiting Bots Reported",
	'MBOTS_HELP_CREDITS_HEADER_NON-VISITING_BOTS' => "Non-Visiting Bots Reported",
	'MBOTS_HELP_CREDITS_HEADER_SPECIAL' => "Special Thanks",
	'MBOTS_HELP_CREDITS_THANKS_CODING' => "Coding help",
	'MBOTS_HELP_CREDITS_THANKS_CURRENT_SCRIPT' => "Current <a href='http://www.phpbb.com/community/viewtopic.php?p=12119145#p12119145'>manage_bots</a> script author",
	'MBOTS_HELP_CREDITS_THANKS_ORIGINAL_SCRIPT' => "Original <a href='http://www.phpbb.com/community/viewtopic.php?p=6194125#p6194125'>add_bots</a> script author",
	'MBOTS_HELP_CREDITS_THANKS_SUGGESTIONS' => "Various suggestions & coding help",
	'MBOTS_HELP_CREDITS_THANKS_TOPIC' => "<a href='http://www.phpbb.com/community/viewtopic.php?f=64&t=935605'>Spiders & bots to add to phpBB</a> topic starter",
	'MBOTS_HELP_DEACTIVATE' => "<p><strong>TO DEACTIVATE BOTS IN YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>n</em>][&%4\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>n</em></tt>: Deactivate bots whose level >= <em>n</em> (if <em>n</em>=0, all bots will be deactivated)<br />
				&mdash; <tt>%4\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_DELETE' => "<p><strong>TO DELETE BOTS FROM YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>n</em>][&%4\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>n</em></tt>: Delete bots whose level >= <em>n</em> (if <em>n</em>=0, all bots will be deleted)<br />
				&mdash; <tt>%4\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_DONATE' => "<p><strong>DONATIONS:</p><p></strong>Want to thank me for writing and maintaining this?  Go to <a href='http://hall.svpocketpc.com/#DONATE'>my donation page</a> to donate via PayPal.</p>",
	'MBOTS_HELP_FOOTER' => "<br /><br />",
	'MBOTS_HELP_HEADER' => "<h2>Pony's Manage_Bots Script Help (Version " . $mbots_version . ") </h2><p>This script adds new bots to your phpBB installation and helps you manage them better.</p>",
	'MBOTS_HELP_HELP' => "<p><strong>TO DISPLAY HELP FOR THIS SCRIPT:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s</tt><br />
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php??</tt> <strong>(Two question marks; works even when not logged in)</strong><br />",
	'MBOTS_HELP_LIST' => "<p><strong>TO LIST BOTS IN YOUR DATABASE:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>n</em>][&%4\$s=1][&%5\$s=1][&%6\$s=1][&%7\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>n</em></tt>: List bots using level = <em>n</em> (for visiting bots) or <em>n</em>+50 (for non-visiting bots) in the listing<br />
				&mdash; <tt>%4\$s=1</tt>: List all bots in the database instead of just ones not in this script<br />
				&mdash; <tt>%5\$s=1</tt>: List bots in a tabular format for readability (not recommended for submitting bots to me)<br />
				&mdash; <tt>%6\$s=1</tt>: Number the rows in the list output (not recommended for submitting bots to me)<br />
				&mdash; <tt>%7\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_HELP_SUPPORT' => "<p><strong>QUESTIONS?</p><p></strong>Ask in the <a href='http://www.phpbb.com/community/viewtopic.php?f=64&t=935605'>Spiders & bots to add to phpBB</a> topic on the phpBB discussion board.  
				Please ensure that you're running the <a href='http://www.phpbb.com/community/viewtopic.php?p=12119145#p12119145'>latest version</a>.</p>",
	'MBOTS_HELP_SYNTAX' => "<p>Call the script with your Web browser (enter it in your browser&rsquo;s address bar).  For example:</p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php</tt><br />
				<p>Replace &ldquo;example.com&rdquo; and &ldquo;phpBB3&rdquo; with your board&rsquo;s domain and sub-directory.</p>
				<p>SYNTAX:  Items in [brackets] are optional; do not type the brackets, but do replace items after the equal signs.</p>",
	'MBOTS_HELP_UPDATE' => "<p><strong>TO UPDATE BOTS ALREADY IN YOUR DATABASE WITH NEWER INFORMATION:</strong></p>
				<tt style='margin-left: 2em;'>http://www.example.com/phpBB3/manage_bots.php?%2\$s=%1\$s[&%3\$s=<em>admin_pw</em>]</tt><br /><br />
				&mdash; <tt>%3\$s=<em>admin_pw</em></tt>: Required admin password if you set the <tt>\$admin</tt> variable<br />",
	'MBOTS_INCORRECT_PASSWORD' => "<strong><span style='color: red;'>Password not correct for user %s!</span><br /><br />",
	'MBOTS_INVALID_OPERATION' => "<span style='color: red;'>Operation %s not supported!</span><br /><br />",
	'MBOTS_INVALID_PARAMETER_VALUE' => "<span style='color: red;'>Invalid value for <strong>%1\$s</strong> parameter: %2\$s</span><br /><br />",
	'MBOTS_IP_CONFLICT' => "<span style='color: red;'>Warning: <em>%1\$s</em>'s IP address %2\%s conflicts with <em>%3\$s</em>'s IP address %4\$s!</span><br /><br />",
	'MBOTS_LIST_COMPLETE' => "<br /><strong>COMPLETE:  Bots listed: %1\$d (out of %2\$d); levels = %3\$d (visiting bots) & %4\$d (non-visiting bots)</strong><br />",
	'MBOTS_NO_CONFLICTING_BOTS' => "No bot conflicts found<br /><br />",
	'MBOTS_NOT_IN_USER_TABLE' => "<span style='color: blue;'>Bot <em>%s</em> not in user table!</span><br /><br />",
	'MBOTS_NOT_APPLICABLE' => "N/A",
	'MBOTS_OPERATION_ACTIVATE' => "activate",
	'MBOTS_OPERATION_ADD' => "add",
	'MBOTS_OPERATION_CONFLICTS' => "conflicts",
	'MBOTS_OPERATION_DEACTIVATE' => "deactivate",
	'MBOTS_OPERATION_DELETE' => "delete",
	'MBOTS_OPERATION_HELP' => "help",
	'MBOTS_OPERATION_LIST' => "list",
	'MBOTS_OPERATION_UPDATE' => "update",
	'MBOTS_PARAMETER_DEBUG' => "debug",
	'MBOTS_PARAMETER_FORMAT' => "format",
	'MBOTS_PARAMETER_LEVEL' => "level",
	'MBOTS_PARAMETER_LISTALL' => "listall",
	'MBOTS_PARAMETER_NUMBER' => "number",
	'MBOTS_PARAMETER_OPERATION' => "operation",
	'MBOTS_PARAMETER_PASSWORD' => "password",
	'MBOTS_SCRIPT_PREFIX' => "MANAGE_BOTS script:  ",
	'MBOTS_UPDATE_COMPLETE' => "<br /><strong>COMPLETE:  Bots checked for updating: %d</strong><br />",
	'MBOTS_UPDATED_BOT' => "Updated bot %s<br />",
	'MBOTS_UPDATED_BOTS' => "<strong>Bots updated: %d</strong><br />",
	'MBOTS_UPDATED_LOG' => "Updated %d bots",
	'MBOTS_UPDATING_BOT_ALREADY_EXISTS' => "<span style='color: red;'>Warning:  %1\$s already in use; can't rename %2\$s!</span><br /><br />",
);

// Change the array index to one of the following values; default = add
// MBOTS_OPERATION_ADD        -- Adds bots with the level <= the specified level
// MBOTS_OPERATION_DELETE     -- Deletes bots with the level >= the specified level
// MBOTS_OPERATION_ACTIVATE   -- Activates bots with the level >= the specified level
// MBOTS_OPERATION_DEACTIVATE -- Deactivates bots with the level >= the specified level
// MBOTS_OPERATION_LIST       -- Lists bots in your database in a format suitable for this script outputting the specified level
// MBOTS_OPERATION_UPDATE     -- Updates the bots in your database using the $updated list below to fix issues with previous lists
// MBOTS_OPERATION_CONFLICTS  -- Checks existing database for bot conflicts
// MBOTS_OPERATION_HELP				-- Displays help
$default_operation = $mbots_lang['MBOTS_OPERATION_ADD'];

// Debugging section (DO NOT MODIFY)
$debug_level = 0;  // Outputs debugging messages (where enabled); added the level values together for output
                   // 0 = no debugging
                   // 1 = entry/exit debugging
                   // 2 = mid-level debugging
                   // 4 = low-level debugging
$debug_update = false;	// If true, call update_bots if $debug_level > 0; otherwise only call update_bots if not debugging 
$debug_errors = false;  // Outputs error messages by pretending to fail
$max_debug_level = 7;
// ***** END CONFIGURATION SECTION *****
  
set_time_limit(0);  
  
// Iniitalize board variables and include important files
define('IN_PHPBB', true);  
$phpbb_root_path = './';  
$phpEx = substr(strrchr(__FILE__, '.'), 1);  
include($phpbb_root_path . 'common.'.$phpEx);  
include($phpbb_root_path . 'includes/functions_user.'.$phpEx);

// Start session management  
$user->session_begin();  
$auth->acl($user->data);  
$user->setup();  
$script_name = $request->escape($symfony_request->getScriptName(), true);
// Output page header
printf('<html>');
printf('<head>');
printf('<title>Pony\'s Manage_Bots Output</title>');
printf('</head>');
printf('<body>');

// Set page end string in case we have to call DIE
$page_end = '</body></html>';

// Check if a debug level was specified on the command line
// WARNING:  If "debug" is specified as a parameter, any variable named $debug seems to be reset to null!
$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_DEBUG'], $debug_level);
if ($temp <> '')
{
	if (($debug_level = check_number($temp, $max_debug_level)) < 0)
	{
		printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_DEBUG'], $temp);
		$debug_level = 0;
	} // if (($debug_level = check_number($temp, $max_debug_level)) < 0)
} // if ($temp <> '')
  
if ($debug_level & 1) echo '>> At start of script<br />';

// Check if help was requested using the "?" operator; you can run this without being logged in!
$display_help = false;
if ($debug_level & 4) echo '>> _SERVER["QUERY_STRING"] = >>' . $script_name . '<<<br />';
if ($script_name == '?')
{
	// Can't call display_help because credits haven't been initialized!
	// Instead force help to be displayed through normal path.
	$display_help = true;
	$default_operation = $mbots_lang['MBOTS_OPERATION_HELP'];
} // if($query_string) == '?')

// Ensure only people with ACP access can run this script
if (!$display_help && (!$auth->acl_get('a_bots') || empty($user->data['is_registered'])))
{
	die(sprintf($mbots_lang['MBOTS_ADMIN_PRIVILEGES_REQUIRED'], $user->data['username']) . $page_end);
} // if ($auth->acl_get('a_bots') && !empty($user->data['is_registered']))

// If the $admin variable is defined, ensure that the user is logged in as that user
if ($admin <> '' && $admin <> $user->data['username'])
{
	die(sprintf($mbots_lang['MBOTS_ADMIN_INCORRECT'], $admin) . $page_end);
} // if ($admin <> '' && $admin <> $user->data['username'])

// Global credit index constants
$gc_credit_idx_name = 0;
$gc_credit_idx_phpbb_url = 1;
$gc_credit_idx_visbots = 2;
$gc_credit_idx_nonvisbots = 3;
$gc_credit_idx_special = 4;
$gc_credit_idx_sort_order = 5;

/* List of credits to insert
 * FORMAT: 'level' => array('username', 'phpBB profile URL', visiting bots count, non-visiting bots count, 'special credits')
 * where level =
 *   0:  phpBB pre-defined bots
 *   1:  phpBB.com additional visiting bots
 *   2:  Marcus Wendel's list of bots (http://phpbb-bots.blogspot.com/)
 *   3:  Young Jedi Knight's visiting bots
 *   4:  Pony99CA's visiting bots
 *   5:  Clava's visiting bots
 *   6:  ricjonhay's visiting bots
 *   7:  roBBx's visiting bots
 *   8:  Sr X's visiting bots
 *   9:  HGN's visiting bots
 *  10:  AmigoJack's visiting bots
 *  11:  millipede's visiting bots
 *  12:  maxwell2's visiting bots
 *  13:  StandBy's visiting bots
 *  14:  ade74's visiting bots
 *  15:  heredia21's visiting bots
 *  16:  TheSnake's visiting bots
 *  17:  natalia26's visiting bots
 *  18:  Puchahawa's visiting bots
 *  19:  T50's visiting bots
 *  20:  Peter77sx's visiting bots
 *  21:  Schwpz's visiting bots
 *  22:  Vinny's visiting bots
 *  23:  lanesharon's visiting bots
 *  24:  leschek's visiting bots
 *  25:  fac7orx's visiting bots
 *  26:  Joshua203's visiting bots
 */
$mbots_credits = array(
// >>> Credits List Start <<<
	'CRED_00' => array('phpBB standard pre-defined bots', '', 51, -1, '', 1000),
	'CRED_01' => array('phpBB extra bots', '', 4, -1, '', 1001),
	'CRED_02' => array('Marcus Wendel', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=6152', 142, 0, 'MBOTS_HELP_CREDITS_THANKS_TOPIC', 1),
	'CRED_03' => array('ReptileGuy', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=447165', 1, 0, '', 2),
	'CRED_04' => array('Young Jedi Knight', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=962935', 30, 237, '', 3),
	'CRED_05' => array('Pony99CA', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=143537', 3, 0, 'MBOTS_HELP_CREDITS_THANKS_CURRENT_SCRIPT', 4),
	'CRED_06' => array('Clava', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=353237', 1, 0, '', 5),
	'CRED_07' => array('ricjonhay', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1222875', 2, 0, '', 6),
	'CRED_07' => array('roBBx', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=467205', 4, 0, '', 7),
	'CRED_09' => array('Sr X', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=298330', 1, 0, '', 8),
	'CRED_10' => array('HGN', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=821755', 1, 0, '', 9),
	'CRED_11' => array('AmigoJack', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1289605', 60, 0, 'MBOTS_HELP_CREDITS_THANKS_SUGGESTIONS', 10),
	'CRED_12' => array('millipede', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=482675', 1, 0, '', 11),
	'CRED_13' => array('maxwell2', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=951565', 1, 0, '', 12),
	'CRED_14' => array('StandBy', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1288269', 2, 0, '', 13),
	'CRED_15' => array('ade74', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1296329', 2, 0, '', 14),
	'CRED_16' => array('heredia21', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1273765', 9, 0, '', 15),
	'CRED_17' => array('TheSnake', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=265871', 2, 0, '', 16),
	'CRED_18' => array('natalia26', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1287940', 1, 0, '', 17),
	'CRED_19' => array('Puchahawa', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1305487', 2, 0, '', 18),
	'CRED_20' => array('T50', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=317815', 1, 0, '', 19),
	'CRED_21' => array('Peter77sx', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=216463', 1, 0, '', 20),
	'CRED_22' => array('Schwpz', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=61230', 4, 0, '', 21),
	'CRED_23' => array('Vinny', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1065865', 2, 0, '', 22),
	'CRED_24' => array('lanesharon', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=94198', 7, 0, '', 23),
	'CRED_25' => array('leschek', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=261820', 2, 0, '', 24),
	'CRED_26' => array('fac7orx', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=848165', 4, 0, '', 25),
	'CRED_27' => array('Joshua203', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1047325', 1, 0, '', 26),
	'CRED_996' => array('Paul', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=153860', 0, 0, 'MBOTS_HELP_CREDITS_THANKS_CODING', 1006),
	'CRED_997' => array('doktornotor', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=1330502', 0, 0, 'MBOTS_HELP_CREDITS_THANKS_CODING', 1005),
	'CRED_998' => array('stokerpiller', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=302443', 0, 0, 'MBOTS_HELP_CREDITS_THANKS_CODING', 1004),
	'CRED_999' => array('raimon', 'http://www.phpbb.com/community/memberlist.php?mode=viewprofile&u=253197', 0, 0, 'MBOTS_HELP_CREDITS_THANKS_ORIGINAL_SCRIPT', 1003),
//'CRED_28' => array('', '', 0, 0, '', 27),
);

// Global bot array index constants
$gc_bot_idx_agent = 0;
$gc_bot_idx_ip = 1;
$gc_bot_idx_level = 2;
$gc_bot_idx_reporter = 3;
$gc_bot_idx_active = 4;
$gc_bot_idx_visit = 5;
$gc_bot_idx_email = 6;
$gc_bot_idx_web = 7;

/* List of bots to insert
 * FORMAT: 'bot_name' => array('agent', 'IP_address', 'insert_level', 'reporter index', active_status=0/1, last_visit, 'E-mail_address', 'Web_site')
 * where insert_level = the credits array index, except
 *  99:  Bad bots
 * 999:  Test bots
*/

// For even more bots, check out http://www.user-agents.org and http://www.useragentstring.com

$bots = array(
// >>> Bot List Start <<<
'123spider [Spider]' => array('123spider-Bot', '', 53, 'CRED_04', 1, 0, '', ''),
'1klik.dk [Bot]' => array('FastCrawler', '', 53, 'CRED_04', 1, 0, '', ''),
'24spider [Spider]' => array('24spider-Robot', '', 53, 'CRED_04', 1, 0, '', ''),
'2Bone Link Checker [Bot]' => array('2Bone', '', 53, 'CRED_04', 1, 0, '', ''),
'50.nu [Bot]' => array('50.nu', '', 2, 'CRED_02', 1, 0, '', ''),
'80legs [Bot]' => array('80legs', '', 2, 'CRED_02', 1, 0, '', ''),
'ABACHO [Bot]' => array('AbachoBOT', '', 53, 'CRED_04', 1, 0, '', ''),
'ABCdatos [Bot]' => array('ABCdatos', '', 53, 'CRED_04', 1, 0, '', ''),
'Aberja [Bot]' => array('Aberja Checkomat', '', 53, 'CRED_04', 1, 0, '', ''),
'Abonti [Bot]' => array('Abonti', '', 2, 'CRED_02', 1, 0, '', ''),
'About [Bot]' => array('About/', '', 53, 'CRED_04', 1, 0, '', ''),
'AboutUs [Bot]' => array('AboutUsBot/', '', 3, 'CRED_04', 1, 0, '', 'http://www.aboutus.org'),
'Acoon [Bot]' => array('AcoonBot/', '', 25, 'CRED_26', 1, 0, 'webmaster65389@acoon.de', 'http://www.acoon.de/robot.asp'),
'Accelobot [Bot]' => array('accelobot', '', 11, 'CRED_12', 1, 0, '', ''),
'Accoona [Bot]' => array('accoona', '', 53, 'CRED_04', 1, 0, '', ''),
'Accoona AI [Agent]' => array('Accoona-AI-Agent/', '', 53, 'CRED_04', 1, 0, '', ''),
'ActiveBookmark [Bot]' => array('ActiveBookmark', '', 53, 'CRED_04', 1, 0, '', ''),
'AddThis [Bot]' => array('AddThis', '', 21, 'CRED_22', 1, 0, 'tech.support@clearspring.com', 'http://www.addthis.com/'),
'AdsBot [Google]' => array('AdsBot-Google', '', 0, 'CRED_00', 1, 0, '', ''),
'AEIWI [Bot]' => array('Aeiwi', '', 53, 'CRED_04', 1, 0, '', ''),
'Aesop [Bot]' => array('AESOP', '', 53, 'CRED_04', 1, 0, '', ''),
'Agada [Bot]' => array('agadine', '', 53, 'CRED_04', 1, 0, '', ''),
'AgHaven [Bot]' => array('Aghaven', '', 23, 'CRED_24', 1, 0, 'Aghaven@aghaven.com', 'http://www.aghaven.com'),
'Ahrefs [Bot]' => array('AhrefsBot', '', 22, 'CRED_23', 1, 0, '', 'http://ahrefs.com/robot'),
'AideRSS [RSS]' => array('AideRSS', '', 3, 'CRED_04', 1, 0, '', ''),
'aiHit [Bot]' => array('aiHitBot/', '', 2, 'CRED_02', 1, 0, 'matthew.hills@aihit.com', 'http://aihit.com'),
'AISearch [Bot]' => array('AISearchBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Aitellu [Bot]' => array('Aitellu', '', 2, 'CRED_02', 1, 0, '', 'http://www.aitellu.com'),
'Alexa [Bot]' => array('ia_archiver', '', 0, 'CRED_00', 1, 0, '', ''),
'Alkaline [Bot]' => array('AlkalineBOT', '', 19, 'CRED_20', 1, 0, '', 'http://alkaline.vestris.com'),
'Allesklar [Bot]' => array('Allesklar', '', 53, 'CRED_04', 1, 0, '', ''),
'Alta Vista [Bot]' => array('Scooter/', '', 0, 'CRED_00', 1, 0, '', ''),
'Altresium [Bot]' => array('Altresium/', '', 10, 'CRED_11', 1, 0, '', 'http://www.altresium.com'),
'Amazon Elastic Cloud [Crawler]' => array('grvcrawler/', '', 4, 'CRED_05', 1, 0, '', ''),
'Amfibi [Bot]' => array('Amfibibot', '', 53, 'CRED_04', 1, 0, '', ''),
'Amidalla [Bot]' => array('amibot', '', 53, 'CRED_04', 1, 0, '', ''),
'Aport [Bot]' => array('Aport', '', 53, 'CRED_04', 1, 0, '', ''),
'Apple Feedreader [Bot]' => array('Apple-PubSub', '', 2, 'CRED_02', 1, 0, '', ''),
'Apple Syndication [Bot]' => array('AppleSyndication', '', 2, 'CRED_02', 1, 0, '', ''),
'Arachnid Crawler [Bot]' => array('ArachBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Arexera [Bot]' => array('X-Crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'Arianna [Bot]' => array('arianna', '', 53, 'CRED_04', 1, 0, '', ''),
'Ask Jeeves [Bot]' => array('Ask Jeeves', '', 0, 'CRED_00', 1, 0, '', ''),
'ASPseek [Bot]' => array('ASPseek/', '', 53, 'CRED_04', 1, 0, '', ''),
'Async Http Client [Bot]' => array('AsyncHttpClient', '', 10, 'CRED_11', 1, 0, '', ''),
'Attentio [Bot]' => array('Attentio', '', 2, 'CRED_02', 1, 0, '', ''),
'August [BadBot]' => array('AugustBot', '2', 2, 'CRED_02', 1, 0, 'augustbot@163.com', ''),
'AustLII [Bot]' => array('Gromit', '', 53, 'CRED_04', 1, 0, '', ''),
'Axada [Bot]' => array('axadine', '', 53, 'CRED_04', 1, 0, '', ''),
'Babaloo [Bot]' => array('BabalooSpider', '', 2, 'CRED_02', 1, 0, '', ''),
'Backtype [Bot]' => array('kame-rt (support@backtype.com)', '', 10, 'CRED_11', 1, 0, 'support@backtype.com', ''),
'Baidu [Spider]' => array('Baiduspider', '', 0, 'CRED_00', 1, 0, 'spiderhelp@baidu.com', 'http://www.baidu.com/search/spider_english.html'),
'Balihoo [Bot]' => array('Balihoo', '', 53, 'CRED_04', 1, 0, '', ''),
'BDProtect [Bot]' => array('BPImageWalker', '', 2, 'CRED_02', 1, 0, '', ''),
'Become [Bot]' => array('BecomeBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Become.com [Bot]' => array('become.com/', '', 53, 'CRED_04', 1, 0, '', ''),
'BeetleBot [Bot]' => array('BeetleBot', '', 24, 'CRED_25', 1, 0, '', ''),
'Begun.ru [Bot]' => array('Begun Robot Crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Bemash [Bot]' => array('bemash', '', 2, 'CRED_02', 1, 0, 'info@bemash.net', 'http://www.bemash.net'),
'Best of the Web [Spider]' => array('BOTW Spider', '', 2, 'CRED_02', 1, 0, '', ''),
'Big Brother [Bot]' => array('Big Brother', '', 53, 'CRED_04', 1, 0, '', ''),
'BigClique [Bot]' => array('BigCliqueBOT', '', 53, 'CRED_04', 1, 0, '', ''),
'Bim Zone [Bot]' => array('bim-zone', '', 53, 'CRED_04', 1, 0, '', ''),
'Bing [Bot]' => array('bingbot/', '', 0, 'CRED_00', 1, 0, '', ''),
'Bintellibot [Bot]' => array('Mozilla/bintellibot', '', 2, 'CRED_02', 1, 0, '', ''),
'Biru [Bot]' => array('Birubot/', '', 10, 'CRED_11', 1, 0, '', ''),
'Bit.ly [Bot]' => array('bitlybot', '', 10, 'CRED_11', 1, 0, '', ''),
'BitTorrent [Bot]' => array('BTbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Bixo Labs [Bot]' => array('bixolabs', '', 10, 'CRED_11', 1, 0, 'crawler@bixolabs.com', 'http://bixolabs.com'),
'Blekkobot [Bot]' => array('Blekkobot', '', 26, 'CRED_27', 1, 0, '', 'http://blekko.com/about/blekkobot'),
'BlogDex [Bot]' => array('BlogBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Bloglines [Bot]' => array('Bloglines', '', 53, 'CRED_04', 1, 0, '', ''),
'BlogScope [Bot]' => array('BlogScope', '', 2, 'CRED_02', 1, 0, '', ''),
'BlogSearch [Bot]' => array('BlogSearch/', '', 25, 'CRED_26', 1, 0, '', 'http://www.icerocket.com'),
'Blue.lu [Bot]' => array('Confuzzledbot', '', 53, 'CRED_04', 1, 0, '', ''),
'BoardReader [Bot]' => array('BoardReader', '', 2, 'CRED_02', 1, 0, '', ''),
'Boitho-dc [Bot]' => array('boitho.com', '', 53, 'CRED_04', 1, 0, '', 'http://www.boitho.com/dcbot.html'),
'Bookdog [Bot]' => array('Bookdog', '', 2, 'CRED_02', 1, 0, '', ''),
'Boston Project [SpamBot]' => array('Boston Project', '', 2, 'CRED_02', 1, 0, '', ''),
'Brandwatch [Bot]' => array('magpie-crawler', '', 2, 'CRED_02', 1, 0, 'contact@brandwatch.com', 'http://www.brandwatch.com'),
'Brandwatch Jakarta [Bot]' => array('Jakarta Commons', '80.82.139', 53, 'CRED_04', 1, 0, '', ''),
'Bunnybot [Bot]' => array('powered by www.buncat.de', '', 53, 'CRED_04', 1, 0, '', ''),
'BuiBui [Bot]' => array('BuiBui', '', 2, 'CRED_02', 1, 0, 'buibui@dadapro.com', 'http://www.dadapro.com'),
'Business.com [Bot]' => array('bdcindexer', '', 53, 'CRED_04', 1, 0, '', ''),
'BuzzRanking [Bot]' => array('BuzzRankingBot', '', 53, 'CRED_04', 1, 0, '', ''),
'CanadianContent [Bot]' => array('RoboCrawl', '', 53, 'CRED_04', 1, 0, '', ''),
'Cazoodle [Bot]' => array('CazoodleBot', '', 3, 'CRED_04', 1, 0, '', ''),
'Ceron News [Bot]' => array('ceron.jp', '', 2, 'CRED_02', 1, 0, 'support@ceron.jp', 'http://ceron.jp'),
'Check Favorites [Bot]' => array('Check Favorites', '', 53, 'CRED_04', 1, 0, '', ''),
'Checkbot [Bot]' => array('Checkbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Checklinks [Linkcheck]' => array('CheckLinks/', '', 53, 'CRED_04', 1, 0, 'james@jmarshall.com', 'http://www.jmarshall.com/tools/cl/'),
'CheckWeb [Bot]' => array('CheckWeb', '', 53, 'CRED_04', 1, 0, '', ''),
'Cipinet [Bot]' => array('CipinetBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Cityreview [Bot]' => array('Cityreview', '', 7, 'CRED_07', 1, 0, '', ''),
'Claymont [Bot]' => array('Claymont.com', '', 53, 'CRED_04', 1, 0, '', ''),
'cligoo [Bot]' => array('CligooRobot/', '', 10, 'CRED_11', 1, 0, '', 'http://www.cligoo.de'),
'Clush [Bot]' => array('Clushbot', '', 53, 'CRED_04', 1, 0, '', ''),
'CMS Worldmap [Bot]' => array('cmsworldmap.com', '', 16, 'CRED_17', 1, 0, '', 'http://static.153.124.40.188.clients.your-server.de/'),
'Cometrics [Bot]' => array('cometrics-bot', '', 53, 'CRED_04', 1, 0, '', ''),
'CommandCom [Bot]' => array('crawly@commandcom.com', '', 53, 'CRED_04', 1, 0, '', ''),
'CommonCrawl [Bot]' => array('CCBot', '', 2, 'CRED_02', 1, 0, '', 'http://www.commoncrawl.org/bot.html'),
'Conpilot [Bot]' => array('conpilot', '', 2, 'CRED_02', 1, 0, '', ''),
'Consumers Union [Bot]' => array('cu-spider', '', 2, 'CRED_02', 1, 0, '', ''),
'ContextWeb [Bot]' => array('ContextAd', '', 2, 'CRED_02', 1, 0, '', 'http://www.contextweb.com'),
'Cosmix [Bot]' => array('cfetch/', '', 53, 'CRED_04', 1, 0, '', ''),
'Cosmoty [Bot]' => array('beautybot', '', 53, 'CRED_04', 1, 0, '', ''),
'CRAWL-E [Crawler]' => array('CRAWL-E/', '', 10, 'CRED_11', 1, 0, '', 'http://code.google.com/p/crawl-e/'),
'Crawler Search [Crawler]' => array('.Crawler-Search.de', '', 53, 'CRED_04', 1, 0, '', ''),
'Crawler0.1 [Crawler]' => array('Crawler0.1', '', 53, 'CRED_04', 1, 0, '', ''),
'CreativeCommons [Bot]' => array('CreativeCommons', '', 53, 'CRED_04', 1, 0, '', ''),
'Crowsnest [Bot]' => array('Crowsnest', '', 2, 'CRED_02', 1, 0, '', 'http://www.crowsnest.tv'),
'Cruiser [Bot]' => array('Internet Cruiser Robot', '', 53, 'CRED_04', 1, 0, '', ''),
'Crystal Semantics [Bot]' => array('CrystalSemanticsBot', '', 15, 'CRED_16', 1, 0, 'info@crystalsemantics.com', 'http://www.crystalsemantics.com/service-navigation/imprint/useragent/'),
'Cuil [Bot]' => array('Twiceler', '', 2, 'CRED_02', 1, 0, '', ''),
'curl [Bot]' => array('curl/', '', 10, 'CRED_11', 1, 0, '', ''),
'Custo [Bot]' => array('Custo', '', 3, 'CRED_04', 1, 0, '', ''),
'Cyber Spyder Link Test [Bot]' => array('CyberSpyder', '', 53, 'CRED_04', 1, 0, '', ''),
'CyberPatrol [Bot]' => array('CyberPatrol', '', 2, 'CRED_02', 1, 0, '', ''),
'Cydral [Bot]' => array('CydralSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'Cynthia [Bot]' => array('Cynthia', '', 53, 'CRED_04', 1, 0, '', ''),
'DailyOrbit [Bot]' => array('Orbiter', '', 53, 'CRED_04', 1, 0, '', ''),
'DailyPerfect [Bot]' => array('DailyPerfect', '', 2, 'CRED_02', 1, 0, '', ''),
'Daum [Bot]' => array('Daumoa', '', 2, 'CRED_02', 1, 0, '', ''),
'Dead Link Check [Bot]' => array('DeadLinkCheck', '', 53, 'CRED_04', 1, 0, '', ''),
'DeepIndex [Bot]' => array('DeepIndex', '', 53, 'CRED_04', 1, 0, '', ''),
'DepSpid [Bot]' => array('DepSpid', '', 53, 'CRED_04', 1, 0, '', ''),
'Desert Realm [Bot]' => array('DesertRealm', '', 53, 'CRED_04', 1, 0, '', ''),
'Die Blinde Kuh [Bot]' => array('Die Blinde Kuh', '', 53, 'CRED_04', 1, 0, '', ''),
'Diffbot [Bot]' => array('Diffbot', '', 2, 'CRED_02', 1, 0, '', ''),
'Diggit! [Bot]' => array('Digger/', '', 53, 'CRED_04', 1, 0, '', ''),
'DiscoveryEngine [Bot]' => array('discobot', '', 3, 'CRED_04', 1, 0, 'discobot@discoveryengine.com', 'http://www.discoveryengine.com/discobot.html'),
'Ditto [Spider]' => array('DittoSpyder', '', 53, 'CRED_04', 1, 0, '', ''),
'DLE_Spider Xrumer [SpamBot]' => array('DLE_Spider', '', 24, 'CRED_25', 1, 0, '', ''),
'DotNetDotCom.org [Bot]' => array('DotBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Dow Jones Searchbot [Bot]' => array('Dow Jones Searchbot', '', 18, 'CRED_19', 1, 0, '', ''),
'Dumbfind [Bot]' => array('Dumbot', '', 53, 'CRED_04', 1, 0, '', ''),
'DZNET [Bot]' => array('Kevin', '', 53, 'CRED_04', 1, 0, '', ''),
'EasyBib [Bot]' => array('EasyBib ', '', 2, 'CRED_02', 1, 0, '', 'http://content.easybib.com/autocite'),
'EchO! [Bot]' => array('EchO!/', '', 53, 'CRED_04', 1, 0, '', ''),
'EliteSys [Bot]' => array('EliteSys SuperBot/', '', 53, 'CRED_04', 1, 0, '', ''),
'EmailSearch [SpamBot]' => array('EmailSearch', '', 53, 'CRED_04', 1, 0, '', ''),
'embed.ly [Bot]' => array('Embedly/', '', 10, 'CRED_11', 1, 0, '', ''),
'Enaball [Crawler]' => array('EnaBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Entireweb Speedy [Spider]' => array('Speedy Spider', '', 2, 'CRED_02', 1, 0, '', ''),
'Envolk [Bot]' => array('envolk', '', 53, 'CRED_04', 1, 0, '', ''),
'Eqentia [Bot]' => array('EQENTIA', '', 2, 'CRED_02', 1, 0, 'info@eqentia.com', 'http://www.eqentia.com'),
'eSobi [Bot]' => array('eSobi', '', 13, 'CRED_14', 1, 0, '', ''),
'Esperanza [Bot]' => array('EsperanzaBot', '', 53, 'CRED_04', 1, 0, '', ''),
'EventMachine [Bot]' => array('EventMachine HttpClient', '', 10, 'CRED_11', 1, 0, '', ''),
'Evri [Bot]' => array('Evrinid Iudex', '', 10, 'CRED_11', 1, 0, '', ''),
'Exabot [Bot]' => array('Exabot/', '', 0, 'CRED_00', 1, 0, '', 'http://exabot.com'),
'Exactseek [Bot]' => array('ExactSeek', '', 53, 'CRED_04', 1, 0, '', ''),
'ExaleadThumbnails [Bot]' => array('Exabot-Thumbnails', '', 3, 'CRED_04', 1, 0, '', ''),
'Exooba [Crawler]' => array('exooba', '', 53, 'CRED_04', 1, 0, '', ''),
'EXPelite [SpamBot]' => array('ExtractorPro', '', 53, 'CRED_04', 1, 0, '', ''),
'Ezooms [Bot]' => array('Ezooms', '', 4, 'CRED_05', 1, 0, 'ezooms.bot@gmail.com', ''),
'Facebook [Bot]' => array('facebookexternalhit', '', 2, 'CRED_02', 1, 0, '', ''),
'Facebook Scraper [Bot]' => array('facebookscraper', '', 53, 'CRED_04', 1, 0, '', ''),
'FairShare [Bot]' => array('fairshare.cc', '', 2, 'CRED_02', 1, 0, '', ''),
'FakeWordpress [SpamBot]' => array('WordPress/', '', 3, 'CRED_04', 1, 0, '', ''),
'Fast Crawler Gold [Bot]' => array('Fast Crawler Gold Edition', '', 53, 'CRED_04', 1, 0, '', ''),
'FAST Enterprise [Crawler]' => array('FAST Enterprise Crawler', '', 0, 'CRED_00', 1, 0, '', ''),
'FAST FirstPage [Bot]' => array('FAST FirstPage retriever', '', 53, 'CRED_04', 1, 0, '', ''),
'FAST MetaWeb [Crawler]' => array('FAST MetaWeb Crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'Fast PartnerSite [Crawler]' => array('Fast PartnerSite Crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'FAST WebCrawler [Crawler]' => array('FAST-WebCrawler/', '', 0, 'CRED_00', 1, 0, '', ''),
'Favorstar [Bot]' => array('favorstarbot', '', 53, 'CRED_04', 1, 0, '', ''),
'FeedDemon [Bot]' => array('FeedDemon', '', 15, 'CRED_16', 1, 0, '', 'http://www.feeddemon.com'),
'Feedreader [Bot]' => array('Newsbrain', '', 2, 'CRED_02', 1, 0, '', 'http://www.feedreader.com/technology'),
'Filangy [Bot]' => array('Filangy', '', 53, 'CRED_04', 1, 0, '', ''),
'Findexa [Crawler]' => array('Findexa Crawler (', '', 53, 'CRED_04', 1, 0, '', ''),
'Fireball [Bot]' => array('Fireball', '', 53, 'CRED_04', 1, 0, '', ''),
'FLR Treato [Bot]' => array('FLR-Bot', '', 23, 'CRED_24', 1, 0, 'botadmin@firstliferesearch.com', 'http://www.firstliferesearch.com'),
'Focuseek [Bot]' => array('focuseekbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Followsite [Bot]' => array('Followsite', '', 2, 'CRED_02', 1, 0, '', ''),
'Francis [Bot]' => array('http://www.neomo.de/', '', 0, 'CRED_00', 1, 0, '', ''),
'Freenewsmobile [Bot]' => array('freenews', '', 2, 'CRED_02', 1, 0, '', 'http://freerange360.com'),
'FULLSearch [Bot]' => array('FULLSearch', '', 53, 'CRED_04', 1, 0, '', ''),
'Funnelback [Bot]' => array('Funnelback', '', 23, 'CRED_24', 1, 0, '', 'http://www.funnelback.com'),
'Furl [Bot]' => array('FurlBot', '', 2, 'CRED_02', 1, 0, 'wn.furlbot@looksmart.net', 'http://www.furl.net'),
'FyberSearch [Spider]' => array('FyberSpider', '', 3, 'CRED_04', 1, 0, '', ''),
'g2 [Crawler]' => array('g2Crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'Gais [Bot]' => array('Gaisbot/', '', 10, 'CRED_11', 1, 0, '', ''),
'Galaxy [Bot]' => array('GalaxyBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Garlik [Bot]' => array('GarlikCrawler', '', 2, 'CRED_02', 1, 0, 'crawler@garlik.com', 'http://www.garlik.com'),
'GBSpider [Spider]' => array('GBSpider v', '', 53, 'CRED_04', 1, 0, '', ''),
'Geigerzaehler [Bot]' => array('http://www.geigerzaehler.org/bot.html', '', 53, 'CRED_04', 1, 0, '', 'http://www.geigerzaehler.org/bot.html'),
'genie [Bot]' => array('genieBot (', '', 53, 'CRED_04', 1, 0, '', ''),
'GeoBot [Bot]' => array('GeoBot/version', '', 53, 'CRED_04', 1, 0, '', ''),
'GeoHasher [Bot]' => array('GeoHasher', '', 7, 'CRED_07', 1, 0, 'geo_hasher@yahoo.com', 'http://geohasher.gotdns.org'),
'Geona [Bot]' => array('GeonaBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Gigablast [Bot]' => array('gigablast.com/', '', 3, 'CRED_04', 1, 0, '', ''),
'Gigabot [Bot]' => array('Gigabot/', '', 0, 'CRED_00', 1, 0, '', ''),
'GingerCrawler [Bot]' => array('GingerCrawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Girafa [Bot]' => array('Girafabot', '', 53, 'CRED_04', 1, 0, '', ''),
'Gnip [Bot]' => array('UnwindFetchor', '', 15, 'CRED_16', 1, 0, 'info@gnip.com', 'http://gnip.com'),
'GoForIt [Bot]' => array('GOFORITBOT', '', 53, 'CRED_04', 1, 0, '', ''),
'GoGuides [Bot]' => array('Goblin', '', 53, 'CRED_04', 1, 0, '', ''),
'Google [Bot]' => array('Googlebot', '', 0, 'CRED_00', 1, 0, '', ''),
'Google Adsense [Bot]' => array('Mediapartners-Google', '', 0, 'CRED_00', 1, 0, '', ''),
'Google AppEngine' => array('AppEngine-Google', '', 10, 'CRED_11', 1, 0, '', ''),
'Google Desktop' => array('Google Desktop', '', 0, 'CRED_00', 1, 0, '', ''),
'Google FeedBurner [Bot]' => array('FeedBurner', '', 15, 'CRED_16', 1, 0, '', '(http://www.feedburner.com'),
'Google Feedfetcher' => array('Feedfetcher-Google', '', 0, 'CRED_00', 1, 0, '', ''),
'Google Search Appliance [Crawler]' => array('gsa-crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Google Sitemap [Bot]' => array('GSMA/', '', 53, 'CRED_04', 1, 0, '', ''),
'Google Web Preview [Bot]' => array('Google Web Preview', '', 2, 'CRED_02', 1, 0, '', ''),
'Google Wireless Transcoder [Bot]' => array('Google Wireless Transcoder', '', 3, 'CRED_04', 1, 0, '', ''),
'goo ichiro [Crawler]' => array('ichiro', '', 0, 'CRED_00', 1, 0, '', 'http://www.goo.ne.jp'),
'Gooro [Spider]' => array('Gooru-WebSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'Guruji [Bot]' => array('GurujiBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Guruji Image [Bot]' => array('GurujiImageBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Hailoo [Bot]' => array('Hailoobot', '', 2, 'CRED_02', 1, 0, '', 'http://www.hailoo.com/en/support/webmaster.htm'),
'Haodewap [Bot]' => array('haodewap', '', 2, 'CRED_02', 1, 0, '', ''),
'Hatena Antenna [Bot]' => array('Hatena Antenna', '', 2, 'CRED_02', 1, 0, '', ''),
'hbtronix [Spider]' => array('hbtronix.spider', '', 53, 'CRED_04', 1, 0, '', ''),
'Heeii [Bot]' => array('Heeii', '', 2, 'CRED_02', 1, 0, '', ''),
'Heise IT-Markt [Crawler]' => array('heise-IT-Markt-Crawler', '', 0, 'CRED_00', 1, 0, '', ''),
'Heritrix [Crawler]' => array('heritrix/1.', '', 0, 'CRED_00', 1, 0, '', ''),
'HMSEbot [SpamBot]' => array('HMSEbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Hogsearch [Bot]' => array('oegp v.', '', 53, 'CRED_04', 1, 0, '', ''),
'Homerweb [Bot]' => array('Homerbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Hoppa! [Bot]' => array('Toutatis', '', 53, 'CRED_04', 1, 0, '', ''),
'Houxou [Crawler]' => array('HouxouCrawler/', '', 53, 'CRED_04', 1, 0, '', ''),
'HP Web PrintSmart [Bot]' => array('HP Web PrintSmart', '', 53, 'CRED_04', 1, 0, '', ''),
'Html Link Validator [Bot]' => array('Html Link Validator', '', 53, 'CRED_04', 1, 0, '', ''),
'HTML2JPG [Bot]' => array('HTML2JPG', '', 53, 'CRED_04', 1, 0, '', ''),
'HTTrack [Bot]' => array('HTTrack', '', 53, 'CRED_04', 1, 0, '', ''),
'Huawei Symantec [Spider]' => array('Huaweisymantecspider', '', 10, 'CRED_11', 1, 0, '', ''),
'IBM Research [Bot]' => array('ibm.com/cs/crawler', '', 0, 'CRED_00', 1, 0, '', ''),
'ICCrawler - ICjobs' => array('ICCrawler - ICjobs', '', 0, 'CRED_00', 1, 0, '', ''),
'IceRocket [Bot]' => array('BlogzIce', '', 53, 'CRED_04', 1, 0, '', ''),
'IconSurf [Bot]' => array('IconSurf', '', 53, 'CRED_04', 1, 0, '', ''),
'IIT Bombay [Bot]' => array('IITB', '', 2, 'CRED_02', 1, 0, '', ''),
'Ilse [Bot]' => array('IlseBot', '', 2, 'CRED_02', 1, 0, '', ''),
'ImageShack [Bot]' => array('ImageShack Image Fetcher', '', 2, 'CRED_02', 1, 0, '', ''),
'Imageshack/Nutch [Bot]' => array('ShackCrawl', '', 2, 'CRED_02', 1, 0, '', ''),
'InAGist [Bot]' => array('InAGist URL Resolver', '', 10, 'CRED_11', 1, 0, '', 'http://inagist.com'),
'Indy Library [BadBot]' => array('Indy Library', '', 53, 'CRED_04', 1, 0, '', ''),
'Infegy [Bot]' => array('Socialradarbot', '', 2, 'CRED_02', 1, 0, '', 'http://www.infegy.com'),
'INFOmine [Bot]' => array('iVia', '', 53, 'CRED_04', 1, 0, '', ''),
'Information Credibility Criteria Project [Bot]' => array('ICC-Crawler', '', 3, 'CRED_04', 1, 0, '', ''),
'InfoSeek SideWinder [Crawler]' => array('Infoseek SideWinder/', '', 53, 'CRED_04', 1, 0, '', ''),
'Inktomi [Bot]' => array('Inktomi', '', 53, 'CRED_04', 1, 0, '', ''),
'Insuranco [Bot]' => array('InsurancoBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Internet Archive [Bot]' => array('archive.org_bot', '', 14, 'CRED_15', 1, 0, '', ''),
'Internet Memory [Bot]' => array('imbot', '', 22, 'CRED_23', 1, 0, '', 'http://internetmemory.org/en/'),
'InternetSeer [Bot]' => array('InternetSeer', '', 3, 'CRED_04', 1, 0, '', ''),
'InternetServicesResearch [Bot]' => array('MSR-ISRCCrawler', '', 53, 'CRED_04', 1, 0, '', ''),
'IPG [Bot]' => array('internet-provider-guenstig.de-Bot', '', 53, 'CRED_04', 1, 0, '', ''),
'IRLbot [Bot]' => array('http://irl.cs.tamu.edu/crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'ISC Open Index [Crawler]' => array('ISC Open Index crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'iScraper [Bot]' => array('IScraperBot/', '', 7, 'CRED_07', 1, 0, '', ''),
'ISC Systems iRc Search [Bot]' => array('ISC Systems iRc Search', '', 53, 'CRED_04', 1, 0, '', ''),
'Iudex [Bot]' => array('+http://gravitext.com/iudex/', '', 10, 'CRED_11', 1, 0, '', 'http://gravitext.com/iudex/'),
'Java [BadBot]' => array('Java/', '', 3, 'CRED_04', 1, 0, '', ''),
'Java1 [Bot]' => array('Java/1', '', 1, 'CRED_01', 1, 0, '', ''),
'JCheckLinks [Linkcheck]' => array('JCheckLinks', '', 53, 'CRED_04', 1, 0, 'thoth@purplefrog.com', 'http://web.purplefrog.com/~thoth/jchecklinks/'),
'JetBrains Omea Reader [Bot]' => array('Omea', '', 2, 'CRED_02', 1, 0, '', ''),
'JikeSpider [Bot]' => array('JikeSpider', '', 2, 'CRED_02', 1, 0, '', 'http://shoulu.jike.com/spider.html'),
'JS-Kit [Bot]' => array('JS-Kit URL Resolver', '', 10, 'CRED_11', 1, 0, '', 'http://js-kit.com'),
'JustSystems [Crawler]' => array('JUST-CRAWLER', '', 2, 'CRED_02', 1, 0, '', ''),
'Jyxo [Bot]' => array('Jyxobot', '', 2, 'CRED_02', 1, 0, '', 'http://jyxo.vybereme.cz'),
'Kalooga [Bot]' => array('Kalooga', '', 2, 'CRED_02', 1, 0, '', ''),
'Karlsruhe Institute of Technology [Bot]' => array('KIT webcrawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Keywen Encyclopedia [Bot]' => array('EasyDL', '', 2, 'CRED_02', 1, 0, '', ''),
'Keywen Encyclopedia Links [Bot]' => array('KeywenBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Kilomonkey [Bot]' => array('kilomonkey', '', 2, 'CRED_02', 1, 0, '', ''),
'KindSight [Bot]' => array('KSCrawler/Nutch-', '', 10, 'CRED_11', 1, 0, '', ''),
'Korean ISA [Bot]' => array('checkprivacy.or.kr', '', 2, 'CRED_02', 1, 0, 'sss@mail.pirst.kr', 'http://www.checkprivacy.or.kr:6600/RS/PRIVACY_FAQ.jsp'),
'Kraehe [Bot]' => array('-DIE-KRAEHE- META-SEARCH-ENGINE/', '', 53, 'CRED_04', 1, 0, '', ''),
'Kungl. biblioteket [Bot]' => array('kulturarw3', '', 2, 'CRED_02', 1, 0, '', ''),
'Kvasir [Bot]' => array('Solbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Larbin [Bot]' => array('larbin_2.6.3', '', 3, 'CRED_04', 1, 0, '', ''),
'Lemur [Crawler]' => array('Lemur', '', 21, 'CRED_22', 1, 0, 'admin@lemurproject.org', 'http://boston.lti.cs.cmu.edu/crawler_12'),
'Lexxe [Bot]' => array('LexxeBot/', '', 10, 'CRED_11', 1, 0, '', 'http://lexxe.com'),
'libwww script [BadBot]' => array('libwww-perl', '', 3, 'CRED_04', 1, 0, '', ''),
'Linguee Multi-Lingual [Bot]' => array('Linguee Bot', '', 9, 'CRED_10', 1, 0, '', ''),
'LinkAlarm [Bot]' => array('LinkAlarm', '', 53, 'CRED_04', 1, 0, '', ''),
'Linkdex [Bot]' => array('linkdex', '', 2, 'CRED_02', 1, 0, 'support@linkdex.com', 'http://www.linkdex.com'),
'LinkedIn [Bot]' => array('LinkedIn/', '', 17, 'CRED_18', 1, 0, '', 'http://www.linkedin.com'),
'LinkLint [Bot]' => array('LinkLint', '', 53, 'CRED_04', 1, 0, '', ''),
'LinkNZ [Bot]' => array('linknzbot', '', 53, 'CRED_04', 1, 0, '', ''),
'LinkWalker [Bot]' => array('LinkWalker', '', 53, 'CRED_04', 1, 0, '', ''),
'Liquida [Spider]' => array('Liquida Spider', '', 10, 'CRED_11', 1, 0, '', ''),
'LiveJournal [Bot]' => array('LiveJournal', '', 2, 'CRED_02', 1, 0, 'webmaster@livejournal.com', 'http://www.livejournal.com'),
'LongURL [Checker]' => array('LongURL API', '', 10, 'CRED_11', 1, 0, '', ''),
'Lookseek [Bot]' => array('Seeker', '', 53, 'CRED_04', 1, 0, '', ''),
'Looksmart [Bot]' => array('MantraAgent', '', 53, 'CRED_04', 1, 0, '', ''),
'Luzaki.org [Bot]' => array('Luzaki', '', 12, 'CRED_13', 1, 0, '', ''),
'L.webis [Crawler]' => array('L.webis', '', 14, 'CRED_15', 1, 0, '', ''),
'Lycos [Bot]' => array('Lycos', '', 53, 'CRED_04', 1, 0, '', ''),
'Lycos [Spider]' => array('Lycos_Spider_', '', 53, 'CRED_04', 1, 0, '', ''),
'Lycosa [BadBot]' => array('LYCOSA', '', 2, 'CRED_02', 1, 0, '', 'http://lycosa.se'),
'Mail.ru [Bot]' => array('Mail.RU', '', 23, 'CRED_24', 1, 0, 'tech@corp.mail.ru', 'http://mail.ru'),
'Majestic-12 [Bot]' => array('MJ12bot/', '', 0, 'CRED_00', 1, 0, '', ''),
'Marvin Medhunt [Bot]' => array('Marvin', '', 53, 'CRED_04', 1, 0, '', ''),
'McAfee Expand [Bot]' => array('MFE_expand', '', 2, 'CRED_02', 1, 0, '', ''),
'McSeek [Bot]' => array('powered by www.McSeek.de', '', 53, 'CRED_04', 1, 0, '', ''),
'Megaglobe [Bot]' => array('Megaglobe', '', 53, 'CRED_04', 1, 0, '', ''),
'Megaproxy [Bot]' => array('ProxyOS', '', 53, 'CRED_04', 1, 0, '', ''),
'MergeFlow [Bot]' => array('MergeFlow', '', 2, 'CRED_02', 1, 0, '', 'http://mergeflow.net/info/pagereader'),
'Metadata Labs [Crawler]' => array('MLBot', '', 2, 'CRED_03', 1, 0, 'mlbot@metadatalabs.com', 'http://www.metadatalabs.com/mlbot/'),
'Metager [Bot]' => array('MetagerBot/', '', 0, 'CRED_00', 1, 0, '', ''),
'Metaspinner [Bot]' => array('Metaspinner', '', 53, 'CRED_04', 1, 0, '', ''),
'MetaURI [Bot]' => array('MetaURI API/', '', 10, 'CRED_11', 1, 0, 'info@metauri.com', 'http://metauri.com'),
'Microsoft Academic Search [Bot]' => array('librabot', '', 2, 'CRED_02', 1, 0, '', ''),
'Microsoft AdCenter [Bot]' => array('MSNPTC/', '', 10, 'CRED_11', 1, 0, '', ''),
'Microsoft Bing/WinHttp [Bot]' => array('WinHttp', '', 2, 'CRED_02', 1, 0, '', ''),
'Microsoft Research [Bot]' => array('MSRBOT', '', 3, 'CRED_04', 1, 0, '', ''),
'Mirago [Bot]' => array('HeinrichderMiragoRobot (', '', 53, 'CRED_04', 1, 0, '', ''),
'Mirago Test [Bot]' => array('Mirago-Test-Robot', '', 53, 'CRED_04', 1, 0, '', ''),
'MirarSearch [Bot]' => array('Mirar Search Indexing Agent', '', 10, 'CRED_11', 1, 0, '', ''),
'MixCat [Bot]' => array('Mixcat Crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'MMSWeb [Bot]' => array('http://www.mmsweb.at/bot.html', '', 53, 'CRED_04', 1, 0, '', ''),
'Mojeek [Bot]' => array('MojeekBot', '', 3, 'CRED_04', 1, 0, '', ''),
'MOMspider [Spider]' => array('MOMspider', '', 53, 'CRED_04', 1, 0, '', ''),
'MoPilot [Spider]' => array('w@pSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'Moreover [Bot]' => array('Moreoverbot', '', 25, 'CRED_26', 1, 0, 'webmaster@moreover.com', 'http://www.moreover.com'),
'Morfeo [Bot]' => array('holmes', '', 53, 'CRED_04', 1, 0, '', ''),
'MP3-Bot [Bot]' => array('MP3-Bot', '', 53, 'CRED_04', 1, 0, '', ''),
'MSIEcrawler [Crawler]' => array('msiecrawler', '', 3, 'CRED_04', 1, 0, '', ''),
'MSN [Bot]' => array('msnbot/', '', 0, 'CRED_00', 1, 0, '', ''),
'MSN Mobile [Bot]' => array('MSMOBOT', '', 2, 'CRED_02', 1, 0, '', ''),
'MSN NewsBlogs' => array('msnbot-NewsBlogs/', '', 0, 'CRED_00', 1, 0, '', ''),
'MSNbot Media' => array('msnbot-media/', '', 0, 'CRED_00', 1, 0, '', ''),
'Munax [Bot]' => array('', '82.99.30', 3, 'CRED_04', 1, 0, '', ''),
'MWI [Bot]' => array('MWI-UCE-Checker', '', 53, 'CRED_04', 1, 0, '', ''),
'MyFamily [Bot]' => array('MyFamilyBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Mylinea [Bot]' => array('Mylinea', '', 53, 'CRED_04', 1, 0, '', ''),
'NationalDirectory [Bot]' => array('NDSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'Naver [Bot]' => array('Yeti', '', 2, 'CRED_02', 1, 0, '', ''),
'Naver2 [Bot]' => array('NaverBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Naver3 [Bot]' => array('nhnbot@naver.com', '', 53, 'CRED_04', 1, 0, '', ''),
'NerdByNature [Bot]' => array('NerdByNature.Bot', '', 10, 'CRED_11', 1, 0, 'info@nerdbynature.net', 'http://www.nerdbynature.net'),
'Netcraft Survey [Bot]' => array('NetcraftSurveyAgent/', '', 10, 'CRED_11', 1, 0, '', ''),
'Netcraft WebServerSurvey [Bot]' => array('Netcraft Web Server Survey', '', 53, 'CRED_04', 1, 0, '', ''),
'netEstate [Crawler]' => array('+http://www.sengine.info/', '', 10, 'CRED_11', 1, 0, 'info@netestate.de', 'http://www.sengine.info'),
'NetMechanic [Bot]' => array('NetMechanic', '', 53, 'CRED_04', 1, 0, '', ''),
'NetNewsWire [RSS]' => array('NetNewsWire/', '', 1, 'CRED_01', 1, 0, 'support@blackpixel.com', 'http://netnewswireapp.com'),
'NetResearchServer [Bot]' => array('NetResearchServer/', '', 53, 'CRED_04', 1, 0, '', ''),
'NetSeer [Bot]' => array('NetSeer', '', 2, 'CRED_02', 1, 0, '', ''),
'NetSprint [Bot]' => array('NewspointBot', '', 3, 'CRED_04', 1, 0, 'informacje@netsprint.pl', 'http://www.netsprint.eu'),
'Netvibes [Bot]' => array('Netvibes', '', 13, 'CRED_14', 1, 0, '', ''),
'NewsFire [RSS]' => array('NewsFire/', '', 1, 'CRED_01', 1, 0, 'feedback@newsfirerss.com', 'http://www.newsfirerss.com'),
'NewzCrawler [RSS]' => array('NewzCrawler/', '', 25, 'CRED_26', 1, 0, 'info@newzcrawler.com', 'http://www.newzcrawler.com'),
'NextLinks [Bot]' => array('findlinks', '', 2, 'CRED_02', 1, 0, '', ''),
'Nextopia [Bot]' => array('Nextopia', '', 53, 'CRED_04', 1, 0, '', ''),
'Nextthing [Bot]' => array('nextthing.org', '', 53, 'CRED_04', 1, 0, '', ''),
'NG-Search [Bot]' => array('NG-Search/', '', 0, 'CRED_00', 1, 0, '', ''),
'Nigma [Crawler]' => array('Nigma', '', 23, 'CRED_24', 1, 0, 'crawler@nigma.ru', 'http://nigma.ru'),
'Nimble [Crawler]' => array('NimbleCrawler', '', 53, 'CRED_04', 1, 0, '', ''),
'NING [Bot]' => array('NING/', '', 10, 'CRED_11', 1, 0, '', ''),
'Njuice [Bot]' => array('NjuiceBot', '', 15, 'CRED_16', 1, 0, '', ''),
'Nokodo [Bot]' => array('NokodoBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Noxtrum [Bot]' => array('noxtrumbot', '', 2, 'CRED_02', 1, 0, 'crawler@noxtrum.com', 'http://noxtrum.com'),
'Nutch [Bot]' => array('http://lucene.apache.org/nutch/', '', 0, 'CRED_00', 1, 0, '', ''),
'Nutch/CVS [Bot]' => array('NutchCVS/', '', 0, 'CRED_00', 1, 0, '', ''),
'ObjectsSearch [Bot]' => array('ObjectsSearch', '', 53, 'CRED_04', 1, 0, '', ''),
'oBot Brand Protection [Bot]' => array('; oBot)', '', 1, 'CRED_01', 1, 0, '', 'http://www.cobion.com'),
'Ocelli [Bot]' => array('Ocelli/', '', 53, 'CRED_04', 1, 0, '', ''),
'Okidoki [Bot]' => array('OkidokiBot/', '', 5, 'CRED_06', 1, 0, '', ''),
'Omgili [Bot]' => array('omgilibot', '', 2, 'CRED_02', 1, 0, '', 'http://omgili.com/Crawler.html'),
'OmniExplorer [Bot]' => array('OmniExplorer_Bot/', '', 0, 'CRED_00', 1, 0, '', ''),
'OneRiot [Bot]' => array('OneRiot', '', 15, 'CRED_16', 1, 0, '', 'http://www.oneriot.com'),
'Onet [Bot]' => array('OnetSzukaj', '', 53, 'CRED_04', 1, 0, '', ''),
'Onet.pl [Bot]' => array('Onet.pl', '', 53, 'CRED_04', 1, 0, '', ''),
'Online link [Validator]' => array('online link validator', '', 0, 'CRED_00', 1, 0, '', ''),
'Openfind [Bot]' => array('openfind.com', '', 53, 'CRED_04', 1, 0, '', ''),
'Openfind 2 [Bot]' => array('Openbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Orange [Spider]' => array('OrangeSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'OrangeAsk [Bot]' => array('OrangeAskBot', '', 16, 'CRED_17', 1, 0, '', 'http://www.orangeask.com'),
'Orbiter [Bot]' => array('http://www.dailyorbit.com/bot.htm', '', 53, 'CRED_04', 1, 0, '', ''),
'over-zealus [Bot]' => array('Opera/5.0 (Windows NT 4.0;US)', '', 53, 'CRED_04', 1, 0, '', ''),
'OWS [Bot]' => array('owsBot', '', 10, 'CRED_11', 1, 0, '', ''),
'Oxide [Bot]' => array('Anthill', '', 53, 'CRED_04', 1, 0, '', ''),
'Pagebull [Bot]' => array('Pagebull', '', 53, 'CRED_04', 1, 0, '', ''),
'panscient [Spider]' => array('panscient.com', '', 3, 'CRED_04', 1, 0, '', ''),
'PaperLi [Bot]' => array('PaperLiBot/', '', 10, 'CRED_11', 1, 0, '', 'http://support.paper.li/entries/20023257-what-is-paper-li'),
'Patsearch [Bot]' => array('Patwebbot', '', 53, 'CRED_04', 1, 0, '', ''),
'Paxle [Bot]' => array('PaxleFramework', '', 2, 'CRED_02', 1, 0, '', ''),
'PEERbot [Bot]' => array('PEERbot', '', 53, 'CRED_04', 1, 0, '', ''),
'PHP [Toolkit]' => array('PHP/', '', 10, 'CRED_11', 1, 0, '', 'http://www.php.net'),
'PHP version tracker [Bot]' => array('PHP version tracker', '', 53, 'CRED_04', 1, 0, '', ''),
'phpBB-SEO [Bot]' => array('phpBB-SEO', '', 53, 'CRED_04', 1, 0, '', ''),
'Picosearch [Bot]' => array('PicoSearch', '', 53, 'CRED_04', 1, 0, '', ''),
'Pingdom [Bot]' => array('Pingdom', '', 53, 'CRED_04', 1, 0, '', ''),
'Pipeline [Bot]' => array('pipeLiner', '', 53, 'CRED_04', 1, 0, '', ''),
'PlantyNet [Bot]' => array('PlantyNet_WebRobot_V', '', 53, 'CRED_04', 1, 0, '', ''),
'Polybot [Bot]' => array('polybot', '', 53, 'CRED_04', 1, 0, '', ''),
'Popdex [Bot]' => array('Popdexter', '', 53, 'CRED_04', 1, 0, '', ''),
'PostPost [Crawler]' => array('PostPost/', '', 10, 'CRED_11', 1, 0, 'crawlers@postpo.st', 'http://postpo.st/crawlers'),
'PostRank [Bot]' => array('PostRank/', '', 10, 'CRED_11', 1, 0, '', 'http://www.postrank.com'),
'Powermarks [Bot]' => array('Powermarks/', '', 10, 'CRED_11', 1, 0, '', ''),
'Powerset [Bot]' => array('zermelo', '', 2, 'CRED_02', 1, 0, '', ''),
'Proximic [Bot]' => array('proximic', '', 3, 'CRED_04', 1, 0, '', ''),
'PycURL [Bot]' => array('PycURL/', '', 10, 'CRED_11', 1, 0, '', ''),
'Python HTTP [Bot]' => array('Python-httplib2/', '', 10, 'CRED_11', 1, 0, '', ''),
'Python URL fetcher [Bot]' => array('Python-urllib/', '', 3, 'CRED_04', 1, 0, '', ''),
'psbot [Picsearch]' => array('psbot', '', 0, 'CRED_00', 1, 0, 'psbot@picsearch.com', 'http://www.picsearch.com/menu.cgi?item=About_Psbot'),
'Qango [Bot]' => array('Qango', '', 53, 'CRED_04', 1, 0, '', ''),
'Qirina Hurdler [Bot]' => array('Qirina Hurdler', '', 10, 'CRED_11', 1, 0, '', 'http://www.qirina.com/hurdler.html'),
'Quepasa [Bot]' => array('QuepasaCreep', '', 53, 'CRED_04', 1, 0, '', ''),
'Radian6 [Bot]' => array('radian6', '', 2, 'CRED_02', 1, 0, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Radian6 Comments [Bot]' => array('R6_CommentReader', '', 2, 'CRED_02', 1, 0, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Radian6 FeedFetcher [Bot]' => array('R6_FeedFetcher', '', 3, 'CRED_04', 1, 0, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Radian6 Primer [Bot]' => array('R6_Primer', '', 7, 'CRED_07', 1, 0, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Rambler.ru [Bot]' => array('StackRambler', '', 2, 'CRED_02', 1, 0, '', ''),
'REAP Project [Bot]' => array('REAP-crawler', '', 53, 'CRED_04', 1, 0, '', ''),
'ReciprocalLinksChecker [Bot]' => array('reciprocal links checker', '', 53, 'CRED_04', 1, 0, '', ''),
'Regios [Bot]' => array('+http://www.regios.org', '', 10, 'CRED_11', 1, 0, '', 'http://www.regios.org'),
'RIX [Bot]' => array('RixBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Robot Genius [Bot]' => array('robotgenius', '', 2, 'CRED_02', 1, 0, '', ''),
'Robots.txt Validator [Bot]' => array('Robots.txt Validator', '', 53, 'CRED_04', 1, 0, '', ''),
'Robozilla [Bot]' => array('Robozilla/', '', 53, 'CRED_04', 1, 0, '', ''),
'RPonline [Bot]' => array('BlitzBOT', '', 53, 'CRED_04', 1, 0, '', ''),
'RSS-Reader [RSS]' => array('RSS-Reader', '', 53, 'CRED_04', 1, 0, '', ''),
'RSS-SPIDER [RSS]' => array('RSS-SPIDER', '', 53, 'CRED_04', 1, 0, '', ''),
'Ruby [Bot]' => array('Ruby/', '', 10, 'CRED_11', 1, 0, '', ''),
'SAI Crawler [Bot]' => array('sai-crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'ScoutJet [Bot]' => array('ScoutJet', '', 2, 'CRED_02', 1, 0, '', ''),
'Scribd [Bot]' => array('ScribdReader/', '', 10, 'CRED_11', 1, 0, 'support@scribd.com', 'http://www.scribd.com'),
'ScrubTheWeb [Bot]' => array('Scrubby', '', 53, 'CRED_04', 1, 0, '', ''),
'Scumbot [Bot]' => array('Scumbot/', '', 53, 'CRED_04', 1, 0, '', ''),
'Search 17 [Bot]' => array('Search17Bot', '', 2, 'CRED_02', 1, 0, '', ''),
'Searchalot [Bot]' => array('SEARCHALOT', '', 53, 'CRED_04', 1, 0, '', ''),
'Searcharoo [Bot]' => array('Searcharoo', '', 2, 'CRED_02', 1, 0, '', 'http://www.searcharoo.net'),
'SearchByUSA [Bot]' => array('SearchByUsa', '', 53, 'CRED_04', 1, 0, '', ''),
'Search.ch [Bot]' => array('search.ch', '', 10, 'CRED_11', 1, 0, '', ''),
'SearchHippo [Bot]' => array('Fluffy the spider', '', 53, 'CRED_04', 1, 0, '', ''),
'SearchMe [Bot]' => array('searchme', '', 2, 'CRED_02', 1, 0, '', ''),
'Searchme Charlotte [Bot]' => array('Charlotte', '', 2, 'CRED_02', 1, 0, '', ''),
'SearchScout [Bot]' => array('ClariaBot', '', 53, 'CRED_04', 1, 0, '', ''),
'SearchUK [Bot]' => array('MegaSheep', '', 53, 'CRED_04', 1, 0, '', ''),
'SecureComputing [Bot]' => array('page_prefetcher', '', 53, 'CRED_04', 1, 0, '', ''),
'Seekport [Bot]' => array('Seekbot/', '', 0, 'CRED_00', 1, 0, '', ''),
'Sensis [Crawler]' => array('Sensis Web Crawler', '', 0, 'CRED_00', 1, 0, '', ''),
'SEO Crawler' => array('SEO search Crawler/', '', 0, 'CRED_00', 1, 0, '', ''),
'Seoma [Crawler]' => array('Seoma [SEO Crawler]', '', 0, 'CRED_00', 1, 0, '', ''),
'SEOkicks [Bot]' => array('SEOkicks', '', 21, 'CRED_22', 1, 0, 'info@seokicks.de', 'http://www.seokicks.de/robot.html'),
'SEOprofiler [Bot]' => array('spbot', '', 2, 'CRED_02', 1, 0, '', ''),
'SEOSearch [Crawler]' => array('SEOsearch/', '', 0, 'CRED_00', 1, 0, '', ''),
'Setooz [Bot]' => array('oozbot', '', 2, 'CRED_02', 1, 0, '', ''),
'Seznam [Bot]' => array('SeznamBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Seznam Screenshot [Bot]' => array('Seznam screenshot-generator', '', 2, 'CRED_02', 1, 0, '', ''),
'Sharegloo [Bot]' => array('sharegloo', '', 2, 'CRED_02', 1, 0, '', ''),
'Shelob [SpamBot]' => array('shelob', '', 53, 'CRED_04', 1, 0, '', ''),
'ShopWiki [Bot]' => array('ShopWiki/1.0', '', 53, 'CRED_04', 1, 0, '', ''),
'Shoula! [Bot]' => array('Shoula', '', 53, 'CRED_04', 1, 0, '', ''),
'SimilarPages [Bot]' => array('SimilarPages', '', 2, 'CRED_02', 1, 0, '', ''),
'SimplePie [Bot]' => array('SimplePie', '', 2, 'CRED_02', 1, 0, '', ''),
'Simply [Bot]' => array('Argus', '', 53, 'CRED_04', 1, 0, '', ''),
'Singingfish Asterias [Bot]' => array('Asterias', '', 53, 'CRED_04', 1, 0, '', ''),
'SISTRIX [Crawler]' => array('SISTRIX Crawler', '', 10, 'CRED_11', 1, 0, 'crawler@sistrix.com', 'http://crawler.sistrix.net'),
'SiteBot [Bot]' => array('sitebot', '', 18, 'CRED_19', 1, 0, '', 'http://www.sitebot.org'),
'Site Valet [Bot]' => array('Valet', '', 53, 'CRED_04', 1, 0, '', ''),
'Sitesearch.ca [Bot]' => array('Reaper', '', 53, 'CRED_04', 1, 0, '', ''),
'SiteSearcher [Bot]' => array('SSearch', '', 53, 'CRED_04', 1, 0, '', ''),
'SiteSell [Bot]' => array('SBIder', '', 3, 'CRED_04', 1, 0, '', 'http://www.sitesell.com/sbider.html'),
'SiteSpider [Bot]' => array('SiteSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'SitiDi [Bot]' => array('SitiDiBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Skaffe [Bot]' => array('Skampy', '', 53, 'CRED_04', 1, 0, '', ''),
'Skizzle [Bot]' => array('SKIZZLE', '', 53, 'CRED_04', 1, 0, '', ''),
'Snap Shots [Bot]' => array('Snapbot', '', 2, 'CRED_02', 1, 0, '', ''),
'Snap Shots Preview [Bot]' => array('SnapPreviewBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Snappy [Bot]' => array('Snappy/', '', 0, 'CRED_00', 1, 0, '', 'http://www.urltrends.com'),
'Snoopy [Bot]' => array('Snoopy', '', 53, 'CRED_04', 1, 0, '', ''),
'SocialMedia [Bot]' => array('SocialMediaBot/', '', 10, 'CRED_11', 1, 0, '', ''),
'SocialSearcher [Bot]' => array('SocialSearcher', '', 2, 'CRED_02', 1, 0, 'sales@social360.com', 'http://social360.com'),
'Sogou [Spider]' => array('Sogou', '', 2, 'CRED_02', 1, 0, '', 'http://www.sogou.com/docs/help/webmasters.htm'),
'SoMusical! [Bot]' => array('MusicWalker', '', 53, 'CRED_04', 1, 0, '', ''),
'Sonic [SpamBot]' => array('EmailSiphon', '', 53, 'CRED_04', 1, 0, '', ''),
'Soso [Spider]' => array('Sosospider', '', 2, 'CRED_02', 1, 0, '', ''),
'Soso Image [Spider]' => array('Sosoimagespider', '', 2, 'CRED_02', 1, 0, '', ''),
'Spinn3r [Bot]' => array('Spinn3r', '', 2, 'CRED_02', 1, 0, '', 'http://spinn3r.com/robot'),
'Startpagina [Bot]' => array('Startpagina', '', 2, 'CRED_02', 1, 0, '', ''),
'Steeler [Crawler]' => array('http://www.tkl.iis.u-tokyo.ac.jp/~crawler/', '', 0, 'CRED_00', 1, 0, '', ''),
'Suchen.de [Bot]' => array('suchen.de', '', 2, 'CRED_02', 1, 0, '', ''),
'suchpad [Bot]' => array('http://www.suchpad.de/bot/', '', 53, 'CRED_04', 1, 0, '', ''),
'Suggy [Crawler]' => array('suggybot ', '', 15, 'CRED_16', 1, 0, '', 'http://blog.suggy.com/was-ist-suggy/suggy-webcrawler/'),
'Summify [Bot]' => array('Summify/', '', 10, 'CRED_11', 1, 0, 'team@summify.com', 'http://summify.com'),
'Superfeedr [Bot]' => array('Superfeedr', '', 2, 'CRED_02', 1, 0, '', ''),
'DomainTools SurveyBot [Bot]' => array('SurveyBot', '', 3, 'CRED_04', 1, 0, '', 'http://www.domaintools.com/webmasters/surveybot.php'),
'Susie [Sync]' => array('!Susie', '', 53, 'CRED_04', 1, 0, '', ''),
'Sygol [Bot]' => array('SygolBot', '', 53, 'CRED_04', 1, 0, '', ''),
'Synthesio [Bot]' => array('Synthesio', '', 2, 'CRED_02', 1, 0, '', ''),
'Synoo [Bot]' => array('SynooBot/', '', 0, 'CRED_00', 1, 0, '', ''),
'Szukacz [Bot]' => array('szukacz', '', 53, 'CRED_04', 1, 0, '', ''),
'TalkTalk [Bot]' => array('http://www.talktalk.co.uk/', '', 10, 'CRED_11', 1, 0, '', 'http://www.talktalk.co.uk'),
'Tbot [Bot]' => array('Tbot/', '', 53, 'CRED_04', 1, 0, '', ''),
'Telekom [Bot]' => array('crawleradmin.t-info@telekom.de', '', 0, 'CRED_00', 1, 0, '', ''),
'The Best Links [Bot]' => array('TheBestLinks.com', '', 6, 'CRED_07', 1, 0, '', ''),
'Thumbshots [Capture]' => array('thumbshots-de-Bot', '', 53, 'CRED_04', 1, 0, '', ''),
'TinEye [Crawler]' => array('TinEye', '', 54, 1, 0, 'crawler@tineye.com', 'http://www.tineye.com/crawler.html'),
'TipTop [Bot]' => array('http://feeltiptop.com', '', 10, 'CRED_11', 1, 0, '', 'http://feeltiptop.com'),
'Topsy [Bot]' => array('Butterfly', '', 2, 'CRED_02', 1, 0, '', ''),
'Trendiction [Bot]' => array('trendictionbot', '', 2, 'CRED_02', 1, 0, 'contact@trendiction.com', 'http://www.trendiction.de/bot'),
'Tribal Fusion [Bot]' => array('expo9', '', 2, 'CRED_02', 1, 0, '', 'http://www.tribalfusion.com'),
'Trovatore [Bot]' => array('IlTrovatore', '', 53, 'CRED_04', 1, 0, '', ''),
'TurnitinBot [Bot]' => array('TurnitinBot/', '', 0, 'CRED_00', 1, 0, '', ''),
'TweetedTimes [Bot]' => array('TweetedTimes Bot/', '', 10, 'CRED_11', 1, 0, 'support@tweetedtimes.com', 'http://tweetedtimes.com'),
'Tweetmeme [Bot]' => array('TweetmemeBot', '', 6, 'CRED_07', 1, 0, '', 'http://tweetmeme.com'),
'Twenga [Bot]' => array('TwengaBot', '', 10, 'CRED_11', 1, 0, '', ''),
'Twikle [Bot]' => array('Twikle/', '', 2, 'CRED_02', 1, 0, 'contact@twikle.com', 'http://www.twikle.com'),
'Twingly [Bot]' => array('Twingly Recon', '', 10, 'CRED_11', 1, 0, '', ''),
'Twisted PageGetter [Bot]' => array('Twisted PageGetter', '', 15, 'CRED_16', 1, 0, '', ''),
'Twitmatic [Bot]' => array('twitmatic', '', 10, 'CRED_11', 1, 0, '', ''),
'Twitter [Bot]' => array('Twitterbot/', '', 10, 'CRED_11', 1, 0, '', 'http://twitter.com'),
'TwitterFeed [Bot]' => array('TwitterFeed', '', 15, 'CRED_16', 1, 0, 'support@twitterfeed.com', 'http://twitterfeed.com'),
'TwitterJobSearch [Bot]' => array('TwitterJobSearch.com', '', 10, 'CRED_11', 1, 0, '', 'http://twitterjobsearch.com'),
'Twitturly [Bot]' => array('Twitturly', '', 10, 'CRED_11', 1, 0, '', ''),
'Twitturls [Bot]' => array('Twitturls', '', 10, 'CRED_11', 1, 0, '', 'http://www.twitturls.com'),
'Twotrees [Bot]' => array('Willow Internet Crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Unister [Bot]' => array('UnisterBot', '', 10, 'CRED_11', 1, 0, 'info@unister-gmbh.de', 'http://www.unister.de'),
'Universal Feed Parser [Bot]' => array('UniversalFeedParser', '', 2, 'CRED_02', 1, 0, '', ''),
'urlresolver [Bot]' => array('urlresolver', '', 10, 'CRED_11', 1, 0, '', ''),
'Vagabondo [Agent]' => array('http://webagent.wise-guys.nl/', '', 53, 'CRED_04', 1, 0, '', ''),
'vBSEO [Bot]' => array('vBSEO', '', 2, 'CRED_02', 1, 0, '', ''),
'vectra-mods [BadBot]' => array('','212.227.101.211', 99, 'CRED_xx', 1, 0, '', ''),
'Visvo [Bot]' => array('VisBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Voila [Bot]' => array('VoilaBot', '', 2, 'CRED_02', 1, 0, '', 'http://www.voila.fr'),
'Voyager [Bot]' => array('voyager/1.0', '', 0, 'CRED_00', 1, 0, '', ''),
'VSW [Crawler]' => array('VSWCrawler', '', 23, 'CRED_24', 1, 0, 'crawler@verticalsearchworks.com', 'http://ews.converasearch.com/crawl.htm'),
'VSW Convera [Crawler]' => array('ConveraCrawler', '', 3, 'CRED_04', 1, 0, 'crawler@verticalsearchworks.com', 'http://ews.converasearch.com/crawl.htm'),
'VSW ERA [Crawler]' => array('EraCrawler', '', 23, 'CRED_24', 1, 0, 'crawler@verticalsearchworks.com', 'http://ews.converasearch.com/crawl.htm'),
'W3 [Sitesearch]' => array('W3 SiteSearch Crawler', '', 0, 'CRED_00', 1, 0, '', ''),
'W3C [Linkcheck]' => array('W3C-checklink/', '', 0, 'CRED_00', 1, 0, '', ''),
'W3C [Validator]' => array('W3C_*Validator', '', 0, 'CRED_00', 1, 0, '', ''),
'W3C CSS Validator [Validator]' => array('W3C_CSS_Validator', '', 53, 'CRED_04', 1, 0, '', ''),
'W3C Feed Validator [Validator]' => array('FeedValidator', '', 3, 'CRED_04', 1, 0, '', ''),
'W3C Markup Validator [Validator]' => array('W3C_Validator', '', 53, 'CRED_04', 1, 0, '', ''),
'W3C P3P Validator [Validator]' => array('P3P Validator', '', 53, 'CRED_04', 1, 0, '', ''),
'Walhello [Bot]' => array('appie', '', 53, 'CRED_04', 1, 0, '', ''),
'Web2PDF [Converter]' => array('web2pdfconvert.com', '', 8, 'CRED_09', 1, 0, '', ''),
'Web Site Optimization [Bot]' => array('', '67.225.164.12', 53, 'CRED_04', 1, 0, '', ''),
'WebAlta [Bot]' => array('WebAlta', '', 2, 'CRED_02', 1, 0, '', ''),
'webcollage [Bot]' => array('webcollage', '', 2, 'CRED_02', 1, 0, '', ''),
'WebCorp [Bot]' => array('WebCorp', '', 2, 'CRED_02', 1, 0, '', ''),
'WebmasterCoffee [Bot]' => array('WebmasterCoffee/', '', 10, 'CRED_11', 1, 0, 'webmaster@webmastercoffee.com', 'http://webmastercoffee.com/en'),
'Webmeasurement [Bot]' => array('webmeasurement-bot', '', 53, 'CRED_04', 1, 0, '', ''),
'Wget [SpamBot]' => array('Wget', '', 2, 'CRED_02', 1, 0, '', ''),
'Whitevector [Crawler]' => array('Whitevector Crawler', '', 2, 'CRED_02', 1, 0, '', ''),
'Wikia URL Routine [Bot]' => array('php_url_routine', '', 53, 'CRED_04', 1, 0, '', ''),
'Wikianswers [Bot]' => array('GrubNG', '', 2, 'CRED_02', 1, 0, '', ''),
'WikiDo [Crawler]' => array('WikiDo', '', 2, 'CRED_02', 1, 0, 'crawler@wikido.com', 'http://www.wikido.com/wikido.php'),
'Wikiwix [Bot]' => array('wikiwix-bot-3.0', '', 53, 'CRED_04', 1, 0, '', ''),
'WillyFogg [Bot]' => array('WillyBot', '', 2, 'CRED_02', 1, 0, '', ''),
'WiseGuys [Bot]' => array('Vagabondo', '', 2, 'CRED_02', 1, 0, '', ''),
'WiseNut [Bot]' => array('http://www.WISEnutbot.com', '', 0, 'CRED_00', 1, 0, '', ''),
'WissenOnline [Bot]' => array('WissenOnline-Bot', '', 53, 'CRED_04', 1, 0, '', ''),
'Worio [Bot]' => array('+http://worio.com', '', 10, 'CRED_11', 1, 0, 'ali@worio.com', 'http://worio.com'),
'WWWeasel [Bot]' => array('WWWeasel Robot v', '', 53, 'CRED_04', 1, 0, '', ''),
'Xaldon [Spider]' => array('Xaldon WebSpider', '', 53, 'CRED_04', 1, 0, '', ''),
'XML Sitemap Generator [Bot]' => array('XML Sitemaps Generator', '', 53, 'CRED_04', 1, 0, '', ''),
'YaCy [Bot]' => array('yacybot', '', 0, 'CRED_00', 1, 0, '', ''),
'Yahoo [Bot]' => array('Yahoo! Slurp', '', 0, 'CRED_00', 1, 0, '', ''),
'YahooCacheSystem [Bot]' => array('YahooCacheSystem', '', 21, 'CRED_22', 1, 0, '', ''),
'Yahoo China [Bot]' => array('Slurp China', '', 20, 'CRED_21', 1, 0, '', 'http://misc.yahoo.com.cn/help.html'),
'Yahoo Japan [Bot]' => array('yahoo.co.jp', '', 2, 'CRED_02', 1, 0, '', ''),
'Yahoo MMCrawler [Bot]' => array('Yahoo-MMCrawler/', '', 0, 'CRED_00', 1, 0, '', ''),
'Yahoo Pipes [Bot]' => array('Yahoo Pipes', '', 2, 'CRED_02', 1, 0, '', 'http://pipes.yahoo.com'),
'Yahoo Search Marketing [Bot]' => array('YahooYSMcm', '', 2, 'CRED_02', 1, 0, '', ''),
'Yahoo Slurp [Bot]' => array('Yahoo! DE Slurp', '', 0, 'CRED_00', 1, 0, '', ''),
'Yahoo! Blogs [Bot]' => array('Yahoo-Blogs', '', 53, 'CRED_04', 1, 0, '', ''),
'Yahoo! Feed Seeker [RSS]' => array('YahooFeedSeeker', '', 3, 'CRED_04', 1, 0, '', ''),
'Yahoo! Mindset [Bot]' => array('Yahoo! Mindset', '', 53, 'CRED_04', 1, 0, '', ''),
'Yahoo! Search Marketing [Crawler]' => array('crawlx', '', 53, 'CRED_04', 1, 0, '', ''),
'Yahoo! SpiderMan [Bot]' => array('SpiderMan', '', 53, 'CRED_04', 1, 0, '', ''),
'Yahoo! Test [Bot]' => array('Yahoo-Test', '', 53, 'CRED_04', 1, 0, '', ''),
'Yahoo! VerticalCrawler [Bot]' => array('Yahoo-VerticalCrawler', '', 53, 'CRED_04', 1, 0, '', ''),
'YahooSeeker [Bot]' => array('YahooSeeker/', '', 0, 'CRED_00', 1, 0, '', ''),
'Yandex [Bot]' => array('Yandex', '', 2, 'CRED_02', 1, 0, 'support@search.yandex.com', 'http://help.yandex.com/search/?id=1112030'),
'Yandex Images [Bot]' => array('YandexImages/', '', 4, 'CRED_05', 1, 0, 'support@search.yandex.com', 'http://help.yandex.com/search/?id=1112030'),
'Yandex Direct [Bot]' => array('YandexDirect/', '', 2, 'CRED_02', 1, 0, 'support@search.yandex.com', 'http://help.yandex.com/search/?id=1112030'),
'Yanga [Bot]' => array('Yanga', '', 2, 'CRED_02', 1, 0, '', ''),
'Yebol [Bot]' => array('YebolBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Yesup [Bot]' => array('YesupBot', '', 3, 'CRED_04', 1, 0, '', ''),
'Yigg [Bot]' => array('', '188.138.56.55', 10, 'CRED_11', 1, 0, '', ''),
'Yodao [Bot]' => array('YodaoBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Youdao [Bot]' => array('YoudaoBot', '', 2, 'CRED_02', 1, 0, '', ''),
'Zerx [Bot]' => array('zerxbot/', '', 53, 'CRED_04', 1, 0, '', ''),
// >>> Bot List End <<<

'zzz Test' => array('Script test', '1.0.0.0', 999, 'CRED_05', 0,  123456, 'test@example.com', 'http://www.example.com'),
// NOTE:  Rows below here are for testing
/* /
'zzz Test1' => array('Script test', '1.2.3.4', 999, 'CRED_05', 0,  123456, 'test@example.com', 'http://www.example.com'),
'zzz Test2' => array('Dupiicate IP address test', '1.0.0.0', 999, 'CRED_05', 0,  123456, 'test@example.com', 'http://www.example.com'),
'zzz Name Change' => array('Name change', '0.0.0.1', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz Agent Change' => array('Agent change', '0.0.0.2', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz IP Change' => array('IP change', '0.0.0.3', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz Active Change' => array('Active change', '0.0.0.4', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz Last Vist Change' => array('Last Visit change', '0.0.0.5', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz E-mail Change' => array('E-mail change', '0.0.0.6', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz Web Change' => array('Web change', '0.0.0.7', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
'zzz All Change' => array('All change','0.0.0.8', 999, 'CRED_05', 0,  0, 'test@example.com', 'http://www.example.com'),
/ */
);

// Update any changed bots
// FORMAT: 'bot_name' => array('new_bot_name', 'new_agent', 'new_IP_address', new_active_status=0/1, new_last_visit, 'new_E-mail_address', 'new_Web_site')
// If something isn't changed, use null string for strings, -1 for integers
// If all items are null strings, the bot will be deleted!
// NOTE:  Active Status and Last Visit not implemented yet (@ToDo)
$gc_updt_idx_name = 0;
$gc_updt_idx_agent = 1;
$gc_updt_idx_ip = 2;
$gc_updt_idx_active = 3;
$gc_updt_idx_visit = 4;
$gc_updt_idx_email = 5;
$gc_updt_idx_website = 6;

$updated = array (
'123spider' => array('123spider [Spider]', '', '', -1, -1, '', ''),
'24spider' => array('24spider [Spider]', '', '', -1, -1, '', ''),
'AboutUs [Bot]' => array('', '', '', -1, -1, '', 'http://www.aboutus.org'),
'Apple-PubSub [Bot]' => array('', '', '', -1, -1, '', ''),
'ASPseek' => array('ASPseek [Bot]', '', '', -1, -1, '', ''),
'Baidu [Spider]' => array('', 'Baiduspider', '', -1, -1, 'spiderhelp@baidu.com', 'http://www.baidu.com/search/spider_english.html'),
'Best of the Web [Bot]' => array('Best of the Web [Spider]', '', '', -1, -1, '', ''),
'Bing/WinHttp [Bot]' => array('Microsoft Bing/WinHttp [Bot]', '', '', -1, -1, '', ''),
'Boitho [Bot]' => array('', '', '', -1, -1, '', ''),
'Boitho-dc [Bot]' => array('', 'boitho.com', '', -1, -1, '', 'http://www.boitho.com/dcbot.html'),
'Brandwatch [Bot]' => array('', '', '', -1, -1, 'contact@brandwatch.com', 'http://www.brandwatch.com'),
'Bunnybot' => array('Bunnybot [Bot]', '', '', -1, -1, '', ''),
'CCBot' => array('CCBot [Bot]', '', '', -1, -1, '', ''),
'CCBot [Bot]' => array('', '', '', -1, -1, '', ''),
'Checklinks [Bot]' => array('Checklinks [Linkcheck]', 'CheckLinks/', '', -1, -1, 'james@jmarshall.com', 'http://www.jmarshall.com/tools/cl/'),
'Cometrics' => array('Cometrics [Bot]', 'cometrics-bot', '', -1, -1, '', 'http://www.cometrics.de'),
'CommonCrawl [Bot]' => array('', '', '', -1, -1, '', 'http://www.commoncrawl.org/bot.html'),
'Convera [Bot]' => array('VSW Convera [Crawler]', 'ConveraCrawler', '', -1, -1, 'crawler@verticalsearchworks.com', 'http://ews.converasearch.com/crawl.htm'),
'Cosmix' => array('Cosmix [Bot]', '', '', -1, -1, '', ''),
'Crawler Search' => array('Crawler Search [Crawler]', '', '', -1, -1, '', ''),
'Diggit!' => array('Diggit! [Bot]', '', '', -1, -1, '', ''),
'DiscoveryEngine [Bot]' => array('', '', '', -1, -1, 'discobot@discoveryengine.com', 'http://www.discoveryengine.com/discobot.html'),
'DomainTools [Bot]' => array('', '', '', -1, -1, '', ''),
'EmailSearch [Spam]' => array('EmailSearch [SpamBot]', '', '', -1, -1, '', ''),
'Entireweb [Bot]' => array('Entireweb Speedy [Spider]', '', '', -1, -1, '', ''),
'Esperanza' => array('Esperanza [Bot]', '', '', -1, -1, '', ''),
'Exabot [Bot]' => array('', 'Exabot/', '', -1, -1, '', 'http://exabot.com'),
'Exalead [Bot]' => array('', '', '', -1, -1, '', ''),
'EXPelite [Spam]' => array('EXPelite [SpamBot]', '', '', -1, -1, '', ''),
'Findexa Crawler' => array('Findexa [Crawler]', '', '', -1, -1, '', ''),
'Furl [Bot]' => array('', '', '', -1, -1, 'wn.furlbot@looksmart.net', 'http://www.furl.net'),
'Galik [Bot]' => array('Garlik [Bot]', '', '', -1, -1, '', ''),
'Garlik [Bot]' => array('', 'GarlikCrawler', '', -1, -1, 'crawler@garlik.com', 'http://www.garlik.com'),
'Geigerzaehler [Bot]' => array('', '', '', -1, -1, '', 'http://www.geigerzaehler.org/bot.html'),
'Goo [Bot]' => array('', '', '', -1, -1, '', ''),
'Google Ads [Bot]' => array('', '', '', -1, -1, '', ''),
'Google Python URL fetcher [Bot]' => array('Python URL fetcher [Bot]', '', '', -1, -1, '', ''),
'Google Search Appliance [Bot]' => array('Google Search Appliance [Crawler]', '', '', -1, -1, '', ''),
'HMSEbot [Spam]' => array('HMSEbot [SpamBot]', '', '', -1, -1, '', ''),
'ichiro [Crawler]' => array('goo ichiro [Crawler]', '', '', -1, -1, '', 'http://www.goo.ne.jp'),
'ICjobs [Bot]' => array('', '', '', -1, -1, '', ''),
'ISC Open Index [Bot]' => array('ISC Open Index [Crawler]', '', '', -1, -1, '', ''),
'JCheckLinks [Bot]' => array('JCheckLinks [Linkcheck]', '', '', -1, -1, 'thoth@purplefrog.com', 'http://web.purplefrog.com/~thoth/jchecklinks/'),
'JS-Kit [Bot]' => array('', '', '', -1, -1, '', 'http://js-kit.com'),
'JustSystems [Bot]' => array('JustSystems [Crawler]', '', '', -1, -1, '', ''),
'Jyxo [Bot]' => array('', '', '', -1, -1, '', 'http://jyxo.vybereme.cz'),
'Metadata Labs [Bot]' => array('Metadata Labs [Crawler]', '', '', -1, -10, 'mlbot@metadatalabs.com', 'http://www.metadatalabs.com/mlbot/'),
'MLbot [bot]' => array('', '', '', -1, -1, '', ''),
'MLbot [Bot]' => array('', '', '', -1, -1, '', ''),
'MMSBot' => array('MMSWeb [Bot]', '', '', -1, -1, '', ''),
'MP3-Bot' => array('MP3-Bot [Bot]', '', '', -1, -1, '', ''),
'MSIEcrawler [Bot]' => array('MSIEcrawler [Crawler]', '', '', -1, -1, '', ''),
'NetSprint [Bot]' => array('', 'NewspointBot', '', -1, -1, 'informacje@netsprint.pl', 'http://www.netsprint.eu'),
'Noxtrum [Bot]' => array('', '', '', -1, -1, 'crawler@noxtrum.com', 'http://noxtrum.com'),
'Omgili [Bot]' => array('', '', '', -1, -1, '', 'http://omgili.com/Crawler.html'),
'PaperLi [Bot]' => array('', '', '', -1, -1, '', 'http://support.paper.li/entries/20023257-what-is-paper-li'),
'PicSearch [Bot]' => array('', '', '', -1, -1, '', ''),
'PlantyNet' => array('PlantyNet [Bot]', '', '', -1, -1, '', ''),
'PostRank [Bot]' => array("", '', '', -1, -1, '', 'http://www.postrank.com'),
'psbot [Picsearch]' => array('', 'psbot', '', -1, -1, 'psbot@picsearch.com', 'http://www.picsearch.com/menu.cgi?item=About_Psbot'),
'Radian6 [Bot]' => array('', '', '', -1, -1, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Radian6 Comments [Bot]' => array('', '', '', -1, -1, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'Radian6 FeedFetcher [Bot]' => array('', '', '', -1, -1, 'support@radian6.com', 'http://www.radian6.com/crawler'),
'SBIder [Bot]' => array('', '', '', -1, -1, '', ''),
'Searchles [Bot]' => array('', '', '', -1, -1, '', ''),
'SimilarPages Nutch [Bot]' => array('', '', '', -1, -1, '', ''),
'SiteSell [Bot]' => array('', '', '', -1, -1, '', 'http://www.sitesell.com/sbider.html'),
'SnapPreview [bot]' => array('', '', '', -1, -1, '', ''),
'SnapPreview [Bot]' => array('', '', '', -1, -1, '', ''),
'Snappy [Bot]' => array('', 'Snappy/', '', -1, -1, '', 'http://www.urltrends.com'),
'Sogou [Bot]' => array('Sogou [Spider]', '', '', -1, -1, '', 'http://www.sogou.com/docs/help/webmasters.htm'),
'Soso [Bot]' => array('Soso [Spider]', '', '', -1, -1, '', ''),
'Soso Image [Bot]' => array('Soso Image [Spider]', '', '', -1, -1, '', ''),
'Speedy [Spider]' => array('', '', '', -1, -1, '', ''),
'Spinn3r [Bot]' => array('', '', '', -1, -1, '', 'http://spinn3r.com/robot'),
'Summify [Bot]' => array('', '', '', -1, -1, 'team@summify.com', ''),
'SurveyBot [Bot]' => array('DomainTools SurveyBot [Bot]', 'SurveyBot', '', -1, -1, '', 'http://www.domaintools.com/webmasters/surveybot.php'),
'W3C Link Checker [Bot]' => array('', '', '', -1, -1, '', ''),
'W3C Semantic Data Extractor [Bot]' => array('', '', '', -1, -1, '', ''),
'Whitevector [Bot]' => array('Whitevector [Crawler]', '', '', -1, -1, '', ''),
'SEOprofiler  [Bot]' => array('SEOprofiler [Bot]', '', '', -1, -1, '', ''),
'Tweetmeme [Bot]' => array('', '', '', -1, -1, '', 'http://tweetmeme.com'),
'Twitter [Bot]' => array('', '', '', -1, -1, '', 'http://twitter.com'),
'TwitterFeed [Bot]' => array('', '', '', -1, -1, 'support@twitterfeed.com', 'http://twitterfeed.com'),
'Voila [Bot]' => array('', '', '', -1, -1, '', 'http://www.voila.fr'),
'Yahoo! Search Marketing' => array('Yahoo! Search Marketing [Crawler]', '', '', -1, -1, '', ''),
'Yandex [Bot]' => array('', '', '', -1, -1, 'support@search.yandex.com', 'http://help.yandex.com/search/?id=1112030'),
'Yandex/YaDirect [Bot]' => array('Yandex Direct [Bot]', 'YandexDirect/', '', -1, -1, 'support@search.yandex.com', 'http://help.yandex.com/search/?id=1112030'),
'Yesup [bot]' => array('Yesup [Bot]', '', '', -1, -1, '', ''),
'Yigg [Bot]' => array('', '', '188.138.56.55,188.138.48.253', -1, -1, '', ''),
// NOTE:  Rows below here are for testing
//'zzz Test' => array('', '','1.2.3.4', -1, -1, '', ''),
//'zzz Name Change' => array('zzz Name Was Changed', '', '', -1, -1, '', ''),
//'zzz Agent Change' => array('', 'Agent was changed', '', -1, -1, '', ''),
//'zzz IP Change' => array('', '', '255.255.255.255', -1, -1, '', ''),
//'zzz Active Change' => array('', '', '', 1, -1, '', ''),
//'zzz Last Vist Change' => array('', '', '', -1, 123456789, '', ''),
//'zzz E-mail Change' => array('', '', '', -1, -1, 'new@example.com', ''),
//'zzz Web Change' => array('', 'Web change', '', -1, -1, '', 'http://changed.example.com'),
//'zzz All Change' => array('zzz Another Name Changed', 'All was changed', '255.254.253.252', 1, 12481632, 'anotherchange@example.com', 'http://anotherchange.example.com'),
);

/*
$bot_ids = array();  
user_get_id_name($bot_ids, array_keys($bots), USER_IGNORE);  
*/

// Command error handling
$err = false;

if ($debug_level & 2)	echo 'Starting command processing<br />';

// If an admin was specified, check for a password
if ($admin <> "")
{
	$pw = get_parameter($mbots_lang['MBOTS_PARAMETER_PASSWORD'], '');
if ($debug_level & 4)	echo 'Admin = ' . $admin . ' ' . $mbots_lang['MBOTS_PARAMETER_PASSWORD'] . ' = ' . $pw . '<br />';
	if (!check_password($admin, $pw))
	{
		die(sprintf($mbots_lang['MBOTS_INCORRECT_PASSWORD'], $admin) . $page_end);
	} // if (!check_password($admin, $pw))
} // if ($admin <> "")

$g_conflicting_bots = '';

// Check if an operation was specified on the command line
// WARNING:  If "operation" is specified as a parameter, any variable named $operation seems to be reset to null!
$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_OPERATION'], '');
if ($temp <> '')
{
	$operation = strtolower($temp);
} else {
	$operation = $default_operation;
} // if ($temp <> '') ... else ...

// Process any non-Level command options
switch ($operation)
{
	case $mbots_lang['MBOTS_OPERATION_ADD']:
// Check if ListAll option was specified on the command line
// WARNING:  If "listall" is specified as a parameter, any variable named $listall seems to be reset to null!
		$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_LISTALL'], '');
		if ($temp <> '')
		{
			if (($list_all = check_number($temp, 1)) < 0)
			{
				printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_LISTALL'], $temp);
				$err = true;
			} else {
				$list_new = !$list_all;
			} // if (($list_new = check_number($temp, 1)) < 0) ... else ...
		} // if ($temp <> '')
if ($debug_level & 4)	echo "In ADD command processing, list_new = " . $list_new . "<br />";
	break;

	case $mbots_lang['MBOTS_OPERATION_LIST']:	
// Check if ListAll option was specified on the command line
// WARNING:  If "listall" is specified as a parameter, any variable named $listall seems to be reset to null!
		$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_LISTALL'], !$list_new);
		if ($temp <> '')
		{
			if (($list_all = check_number($temp, 1)) < 0)
			{
				printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_LISTALL'], $temp);
				$err = true;
			} else {
				$list_new = !$list_all;
			} // if (($list_new = check_number($temp, 1)) < 0) ... else ...
		} // if ($temp <> '')
if ($debug_level & 4)	echo "In LIST command processing, list_new = " . $list_new . "<br />";

// Check if Format option was specified on the command line
// WARNING:  If "format" is specified as a parameter, any variable named $format seems to be reset to null!
		$list_format = 0;
		$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_FORMAT'], false);
		if ($temp <> '')
		{
			if (($list_format = check_number($temp, 1)) < 0)
			{
				printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_FORMAT'], $temp);
				$err = true;
			} // if (($list_format = check_number($temp, 1)) < 0)
		} // if ($temp <> '')
if ($debug_level & 4)	echo "In LIST command processing, " . $mbots_lang['MBOTS_PARAMETER_FORMAT'] . " = " . $format . "<br />";

// Check if number option was specified on the command line
// WARNING:  If "number" is specified as a parameter, any variable named $format seems to be reset to null!
		$list_number = 0;
		$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_NUMBER'], false);
		if ($temp <> '')
		{
			if (($list_number = check_number($temp, 1)) < 0)
			{
				printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_NUMBER'], $temp);
				$err = true;
			} // if (($list_number = check_number($temp, 1)) < 0)
		} // if ($temp <> '')
if ($debug_level & 4)	echo "In LIST command processing, " . $mbots_lang['MBOTS_PARAMETER_NUMBER'] . " = " . $number . "<br />";
		break;
		
	// If displaying help, don't do automatic update
	case $mbots_lang['MBOTS_OPERATION_HELP']:
		$display_help = true;
		break;

	case $mbots_lang['MBOTS_OPERATION_ACTIVATE']:
	case $mbots_lang['MBOTS_OPERATION_DEACTIVATE']:
	case $mbots_lang['MBOTS_OPERATION_CONFLICTS']:
	case $mbots_lang['MBOTS_OPERATION_DELETE']:
	case $mbots_lang['MBOTS_OPERATION_UPDATE']:
		break;

default:
		printf($mbots_lang['MBOTS_INVALID_OPERATION'], $operation);
		display_help();
		$err = true;
		break;
} // switch ($operation)

// Check if a level was specified on the command line
// WARNING:  If "level" is specified as a parameter, any variable named $level seems to be reset to null!
$temp = get_parameter($mbots_lang['MBOTS_PARAMETER_LEVEL'], $default_level);
if ($temp <> '')
{
	if (($level = check_number($temp, $max_level)) < 0)
	{
		printf($mbots_lang['MBOTS_INVALID_PARAMETER_VALUE'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $temp);
		$err = true;
	} // if (($level = check_number($temp, $max_level)) < 0)
} else {
	$level = $default_level;
} // if ($temp <> '') ... else ...
if ($debug_level & 4)	echo "In general command processing, " . $mbots_lang['MBOTS_PARAMETER_LEVEL'] . " = " . $level . "<br />";

if ($err) die($page_end);

// Always update the bots (unless debugging in some cases)
if (($debug_level == 0) || ($debug_update))
{ 
	$auto_update = true;
	if (!$display_help) $bots_checked = update_bots($updated);
} else {
	$auto_update = false;
	echo 'update_bots NOT being called<br />';
} // if (($debug_level == 0) || ($debug_update)) ... else ...

// Display donation information after commands are run unless Help displayed
$donation_request = true;

// Perform the requested operation
switch ($operation)
{
	// Adding bots
	case $mbots_lang['MBOTS_OPERATION_ADD']:
		add_bots($bots, $list_new, $level);
		break;

	// Updating bots
	case $mbots_lang['MBOTS_OPERATION_UPDATE']:
		if (!$auto_update) $bots_checked = update_bots($updated);
    printf($mbots_lang['MBOTS_UPDATE_COMPLETE'], $bots_checked);
		break;

	// Deleting bots
	case $mbots_lang['MBOTS_OPERATION_DELETE']:
		delete_bots($bots, $level, true);
		break;

	// Activating bots
	case $mbots_lang['MBOTS_OPERATION_ACTIVATE']:
		change_bot_activations($bots, $level, true);
		break;

	// Deactivating bots
	case $mbots_lang['MBOTS_OPERATION_DEACTIVATE']:
		change_bot_activations($bots, $level, false);
		break;

	// Listing bots
	case $mbots_lang['MBOTS_OPERATION_LIST']:
		list_bots($bots, $list_new, $level, $list_format, $list_number);
		break;

	// Checking bot conflicts
	case $mbots_lang['MBOTS_OPERATION_CONFLICTS']:
		if ($auto_update) $bots_checked = update_bots($updated);
		conflicting_bots();
		break;

	// Displaying help
	case $mbots_lang['MBOTS_OPERATION_HELP']:
		$donation_request = false;
		display_help();
		break;

	default:
		break;  // Should never happen because it's caught above
} // switch ($operation)

// Display donation request if not displayed already
if ($donation_request) display_donation();

if ($debug_level & 1) echo '<< At script exit<br />';

// Output page end
printf('</body>');
printf('</html>');

exit;
// END MAIN CODE
// START FUNCTION DEFINITIONS
 
//
// Add the search bots into the database 
// This code should be used in execute_last if the source database did not have bots 
// If you are converting bots this function should not be called 
// @ToDo We might want to look at sharing the bot list between the install code and this code for consistency 
//  
function add_bots($bots, $list_new, $level)  
{  
	global $db, $config, $cache;
	global $gc_bot_idx_agent, $gc_bot_idx_ip, $gc_bot_idx_level, $gc_bot_idx_reporter, $gc_bot_idx_active, 
	       $gc_bot_idx_visit, $gc_bot_idx_email, $gc_bot_idx_web;
  global $g_conflicting_bots;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering add_bots<br />';

	$bot_total_count = 0;
	$bot_level_count = 0;
	$bots_added = 0;
	
	// Check for bot group and create it if necessary  
	$group_id = check_bot_group();
	if (!$group_id)  
	{
		printf($mbots_lang['MBOTS_CREATING_GROUP']);
		add_default_groups();
		$group_id = check_bot_group();
	} // if (!$group_id)
	
	// Get the bot group colour
	$sql = 'SELECT group_colour FROM ' . GROUPS_TABLE . ' WHERE group_id = ' . $group_id;  
	$result = $db->sql_query($sql);  
	$bot_colour = $db->sql_fetchfield('group_colour', false, $result);  
	$db->sql_freeresult($result);

if ($debug_level & 4) echo "Bot colour = '" . $bot_colour . "'<br />";
	if ($bot_colour == '') $bot_colour = '9E8DA7';
  
  // Add the bots
	foreach ($bots as $bot_name => $bot_ary)  
	{
		$bot_total_count++;
		
		// Check if bot level is sufficient
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' level ' . $bot_ary[$gc_bot_idx_level] . ' <= '. $level . '<br />';
		if ($bot_ary[$gc_bot_idx_level] > $level) continue;
		
		$bot_level_count++;
		  
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' exists<br />';
		$user_id = bot_defined($bot_name, true);
		if (!$user_id)  
		{
			
			$user_row = array(  
			'user_type'            => USER_IGNORE,  
			'group_id'            => $group_id,  
			'username'            => $bot_name,  
			'user_regdate'         => time(),  
			'user_password'         => '',  
			'user_colour'         => $bot_colour,  
			'user_email'         => $bot_ary[$gc_bot_idx_email],  
		 
			'user_lastvisit'         => $bot_ary[$gc_bot_idx_visit],  
			'user_lang'            => $config['default_lang'],  
			'user_style'         => $config['default_style'],  
			'user_timezone'         => $config['board_timezone'],  
			'user_allow_massemail'   => 0,  
			);
			
			$user_id = user_add($user_row);
			
			if ($user_id)  
			{  
				printf($mbots_lang['MBOTS_ADDING_BOT'], $bot_name);
				similar_bots($bot_name, $bot_ary[$gc_bot_idx_agent], $bot_ary[$gc_bot_idx_ip]);
				
				$sql = 'INSERT INTO ' . BOTS_TABLE . ' ' . $db->sql_build_array('INSERT', array(  
				'bot_active'   => $bot_ary[$gc_bot_idx_active],  
				'bot_name'      => $bot_name,  
				'user_id'      => $user_id,  
				'bot_agent'      => $bot_ary[$gc_bot_idx_agent],  
				'bot_ip'      => $bot_ary[$gc_bot_idx_ip])  
				);  
				$db->sql_query($sql);
				$bots_added++;
			} else {
				printf($mbots_lang['MBOTS_ADDING_BOT_FAILED'], $bot_name);
			} // if ($user_id) ... else ...
		} else {
			if (!$list_new)
			{
				printf($mbots_lang['MBOTS_ADDING_BOT_ALREADY_DEFINED'], $bot_name);
			}
		} // if (!$user_id) ... else ...
	} // foreach ($bots as $bot_name => $bot_ary)

	// Output list of conflicting bots
if ($debug_level & 4) echo "In add_bots, conflicting bot list = " . $g_conflicting_bots . "<br />";

  list_conflicting_bots($g_conflicting_bots, '');
	
  // Output final status messages
	printf($mbots_lang['MBOTS_ADD_COMPLETE'], $bots_added, $bot_level_count, $level);
	printf($mbots_lang['MBOTS_CHECKED'], $bot_total_count);
	
	// Clear the cache and write admin log message if bots were added
	if ($bots_added)
	{
		$cache->destroy('_bots');
		$message = $mbots_lang['MBOTS_SCRIPT_PREFIX'] . sprintf($mbots_lang['MBOTS_ADDED_LOG'], $bots_added, $level);
		add_log('admin', 'LOG_BOT_ADDED', $message);
	} // if ($bots_added)

if ($debug_level & 1) echo '>> Exiting add_bots<br />';

} // End add_bots function

//
// Check for the Bot group in the database
//
function check_bot_group()
{
	global $db, $config;
	global $mbots_lang, $debug_level;
	
	$sql = 'SELECT group_id FROM ' . GROUPS_TABLE . " WHERE group_name = 'BOTS'";  
	$result = $db->sql_query($sql);  
	$group_id = (int) $db->sql_fetchfield('group_id', false, $result);  
	$db->sql_freeresult($result);

if ($debug_level & 4) echo 'Bot group = ' . $group_id . '<br /><br />';
	return $group_id;
} // End check_bot_group function
  
//
// Change the bot's active status in the database
//
function update_bot_activation($user_id, $activate)
{
	global $db, $config;
	global $mbots_lang, $debug_level;

	// Change activation status of bot in bots table
	$sql = 'UPDATE ' . BOTS_TABLE . ' SET bot_active = ' . (int) $activate . ' WHERE user_id = ' . "'" . $user_id . "'";
	$db->sql_query($sql);

} // End update_bot_activation function

// 
// Change activation status of search bots in the database 
//  
function change_bot_activations($bots, $level, $activate)  
{  
	global $db, $config, $cache;
	global $gc_bot_idx_agent, $gc_bot_idx_ip, $gc_bot_idx_level, $gc_bot_idx_reporter, $gc_bot_idx_active, 
	       $gc_bot_idx_visit, $gc_bot_idx_email, $gc_bot_idx_web;
	global $mbots_lang, $debug_level;
	  
if ($debug_level & 1) echo '>> Entering change_bot_activations<br />';

	$bot_total_count = 0;
	$bot_level_count = 0;
	$bots_changed = 0;
		  
	$group_id = check_bot_group();
	if (!$group_id)  
	{
		printf($mbots_lang['MBOTS_GROUP_NOT_DEFINED']);
		return;
	} // if (!$group_id)
	
	foreach ($bots as $bot_name => $bot_ary)  
	{
		$bot_total_count++;
		
		// Check if bot level is sufficient
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' level ' . $bot_ary[$gc_bot_idx_level] . ' >= '. $level . '<br />';
		if ($bot_ary[$gc_bot_idx_level] < $level) continue;
		
		// Check if activation staus is different
		$bot_level_count++;
		  
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' exists<br />';
		$user_id = bot_defined($bot_name, true);
		if ($user_id)  
		{
			// Get bot's current active status
			$sql = 'SELECT bot_active FROM ' . BOTS_TABLE . ' WHERE bot_name = ' . "'" . $bot_name . "'";
			$result = $db->sql_query($sql); 
			$bot_active = (bool) $db->sql_fetchfield('bot_active', false, $result);  
			$db->sql_freeresult($result);
			
			// If bot's active status different from command, update the bot
			if ($bot_active <> $activate)
			{
				if ($activate)
				{
					printf($mbots_lang['MBOTS_ACTIVATING_BOT'], $bot_name);
				} else {
					printf($mbots_lang['MBOTS_DEACTIVATING_BOT'], $bot_name);
				} // if ($activate) ... else ...
				update_bot_activation($user_id, $activate);
				$bots_changed++;
			} // if ($bot_active <> $activate)
		} else {
			printf($mbots_lang['MBOTS_NOT_IN_USER_TABLE'], $bot_name);
		} // if (!$user_id) ... else ...
	} // foreach ($bots as $bot_name => $bot_ary)

if ($debug_level & 4) echo 'Bots changed = ' . $bots_changed . '; bots at level = ' . $bot_level_count . '; level = ' . $level . '<br />';
	if ($activate)
	{
		printf($mbots_lang['MBOTS_ACTIVATE_COMPLETE'], $bots_changed, $bot_level_count, $level);
	} else {
		printf($mbots_lang['MBOTS_DEACTIVATE_COMPLETE'], $bots_changed, $bot_level_count, $level);
	} // if ($activate) ... else
	printf($mbots_lang['MBOTS_CHECKED'], $bot_total_count);
	
	// Clear the cache and write admin log message if bots were deleted
	if ($bots_changed)
	{
		$cache->destroy('_bots');
		
		if ($activate)
		{
			$message = sprintf($mbots_lang['MBOTS_ACTIVATED_LOG'], $bots_changed, $level);
		} else {
			$message = sprintf($mbots_lang['MBOTS_DEACTIVATED_LOG'], $bots_changed, $level);
		} // if ($activate) ... else
		$message = $mbots_lang['MBOTS_SCRIPT_PREFIX'] . $message;
		add_log('admin', 'LOG_BOT_UPDATED', $message);
	} // if ($bots_changed)

if ($debug_level & 1) echo '<< Exiering change_bot_activations<br />';
} // End change_bot_activations function

//
// Delete a bot from the database
//
function remove_bot($user_id)
{
	global $db, $config;
	global $mbots_lang, $debug_level;

	// Remove bot from user table, user group table and most other tables (even though most aren't applicable to bots)
	user_delete('remove', $user_id);

	// Remove bot from bots table
	$sql = 'DELETE FROM ' . BOTS_TABLE . ' WHERE user_id = ' . $user_id;
	$db->sql_query($sql);

} // End remove_bot function

//
// Delete the search bots from the database 
//  
function delete_bots($bots, $level)  
{  
	global $db, $config, $cache;
	global $gc_bot_idx_agent, $gc_bot_idx_ip, $gc_bot_idx_level, $gc_bot_idx_reporter, $gc_bot_idx_active, 
	       $gc_bot_idx_visit, $gc_bot_idx_email, $gc_bot_idx_web;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering delete_bots<br />';
	  
	$bot_total_count = 0;
	$bot_level_count = 0;
	$bots_deleted = 0;
		  
	$group_id = check_bot_group();
	if (!$group_id)  
	{
		printf($mbots_lang['MBOTS_GROUP_NOT_DEFINED']);
		return;
	} // if (!$group_id)
  
	foreach ($bots as $bot_name => $bot_ary)  
	{
		$bot_total_count++;
		
		// Check if bot level is sufficient
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' level ' . $bot_ary[$gc_bot_idx_level] . ' >= '. $level . '<br />';
		if ($bot_ary[$gc_bot_idx_level] < $level) continue;
		
		$bot_level_count++;
		  
if ($debug_level & 4) echo 'Checking if bot ' . $bot_name . ' exists<br />';
		$user_id = bot_defined($bot_name, true);
		if ($user_id)  
		{
			printf($mbots_lang['MBOTS_DELETING_BOT'], $bot_name);
			remove_bot($user_id);

			$bots_deleted++;
		} else {
			printf($mbots_lang['MBOTS_NOT_IN_USER_TABLE'], $bot_name);
		} // if (!$user_id) ... else ...
	} // foreach ($bots as $bot_name => $bot_ary)

	printf($mbots_lang['MBOTS_DELETE_COMPLETE'], $bots_deleted, $bot_level_count, $level);
	printf($mbots_lang['MBOTS_CHECKED'], $bot_total_count);
	
	// Clear the cache and write admin log message if bots were deleted
	if ($bots_deleted)
	{
		$cache->destroy('_bots');
		
		$message = $mbots_lang['MBOTS_SCRIPT_PREFIX'] . sprintf($mbots_lang['MBOTS_DELETED_LOG'], $bots_deleted, $level);
		add_log('admin', 'LOG_BOT_DELETE', $message);
	} // if ($bots_deleted)

if ($debug_level & 1) echo '<< Exiting delete_bots<br />';

  return $bots_deleted;
} // End delete_bots function

//
// List the search bots from the database 
//  
function list_bots($bots, $list_new, $default_level, $format, $number = false)
{
	global $db, $config;
	global $mbots_lang, $debug_level;
		
if ($debug_level & 1) echo '>> Entering list_bots<br />';

	$bot_count = 0;
	$bot_total_count = 0;
	$increment = 50; // Default increment value for non-visiting bots
	$bot_number = "<td style='text-align: left; vertical-align: top'>";  // Bot count string
	
	$sql = 'SELECT bot_name, bot_agent, bot_ip, bot_active FROM ' . BOTS_TABLE . ' WHERE 1 ORDER BY bot_name';
	$result = $db->sql_query($sql); 

  // Write output (possibly formatted)
  if ($format)
	{
	  $fmt_start_text = "<td style='text-align: left; vertical-align: top;'>";
	  $fmt_start_num = "<td style='text-align: right; vertical-align: top;'>";
	  $fmt_end = '</td>';
	} else {
	  $fmt_start_text = '';
	  $fmt_start_num = '';
	  $fmt_end = '';
	} //if ($format) ... else ...
  echo '<table border="1">';
  if ($format)
  {
  	if ($number)
  	{
  		echo '<col width="5%" />';   // Bot number
  	} // if ($number)
	  echo '<col width="33%" />';   // Bot name
	  echo '<col width="25%" />';   // Bot agent
	  echo '<col width="17%" />';   // Bot IP address
	  echo '<col width="*" />';  // Bot level
	  echo '<col width="*" />';  // Bot reporter
	  echo '<col width="*" />';  // Bot active
	  echo '<col width="*" />';  // Bot visited
	  echo '<col width="*" />';  // Bot E-mail
	  echo '<col width="*" />';  // Bot URL
	  echo '<thead><tr>';
  	if ($number)
  	{
  		echo "<th style='vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_NUMBER'] . "</th>";
  	} // if ($number)
	  echo "<th style='text-align: left; vertical-align: top;'>". $mbots_lang['MBOTS_HEADER_BOT_NAME'] . "</th>";
	  echo "<th style='vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_USER_AGENT'] . "</th>";
	  echo "<th style='text-align: left; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_IP_ADDRESS'] . "</th>";
	  echo "<th style='text-align: center; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_LEVEL'] . "</th>";
	  echo "<th style='text-align: center; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_REPORTER'] . "</th>";
	  echo "<th style='text-align: center; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_ACTIVE'] . "</th>";
	  echo "<th style='text-align: center; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_LAST_VISIT'] . "</th>";
	  echo "<th style='text-align: left; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_EMAIL'] . "</th>";
	  echo "<th style='text-align: left; vertical-align: top;'>" . $mbots_lang['MBOTS_HEADER_BOT_WEB_SITE'] . "</th>";
	  echo '</tr></thead>';
	} //   if ($format)
	while ($row = $db->sql_fetchrow($result))
	{
		$bot_total_count++;
		$bot_name = $row['bot_name'];
		if ($list_new)
		{
if ($debug_level & 4) echo '<tr>' . $bot_name . ' in array = ' . array_key_exists($bot_name, $bots) . '</tr>';

			if (array_key_exists($bot_name, $bots))
				continue;
		} // if ($list_new)
		
		// Check if bot has visited and get E-mail and Web site information
		// WARNING:  Use different SQL result variable to avoid freeing the previous query
		$sql = 'SELECT user_lastvisit, user_email FROM ' . USERS_TABLE . " WHERE username = '" . $bot_name . "'";  
		$user_result = $db->sql_query($sql);
		$user_row = $db->sql_fetchrow($user_result);
		$user_visit = (int) $user_row['user_lastvisit'];  
		$user_email = $user_row['user_email'];  
  
		$db->sql_freeresult($user_result);
		$user_visit == 0 ? $level = $default_level + $increment : $level = $default_level;
		
		// List bot found
		$bot_count++;
  	if ($number)
  	{
  		$bot_number = "<td style='text-align: right; vertical-align: top;'>" . $bot_total_count . ":&nbsp;&nbsp;</td><td style='text-align: left; vertical-align: top;'>";
  	} // if ($number)
		echo "<tr>" . $bot_number . "'" . $bot_name . "'" . $fmt_end . 
									$fmt_start_text . " => array('" . $row['bot_agent'] . "', " . $fmt_end .
																			$fmt_start_text . "'" . $row['bot_ip'] . "', " . $fmt_end . 
																			$fmt_start_num . $level . ", " . $fmt_end .
																			$fmt_start_text . "'CRED_'" . $default_level . "', " . $fmt_end .
																			$fmt_start_num . $row['bot_active'] . ", " . $fmt_end .
																			$fmt_start_num . $user_visit . ", " . $fmt_end .
																			$fmt_start_text . "'" . $user_email . "', " . $fmt_end . 
																			
																	")," . "</td></tr>";
	} // while ($row = $db->sql_fetchrow($result))

	$db->sql_freeresult($result);
  echo '</table>';

	printf($mbots_lang['MBOTS_LIST_COMPLETE'], $bot_count, $bot_total_count, $default_level, $default_level+$increment);
	
if ($debug_level & 1)	echo '<< Exiting list_bots<br />';
	return;
} // End list_bots function

//
// Update any search bots with new information
//  
function update_bots($bots)
{
	global $db, $config, $cache;
	global $gc_updt_idx_name, $gc_updt_idx_agent, $gc_updt_idx_ip, $gc_updt_idx_active,
         $gc_updt_idx_visit, $gc_updt_idx_email, $gc_updt_idx_website;
  global $g_conflicting_bots;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering update_bots<br />';

	$bots_checked = 0;
	$bots_updated = 0;
	$bots_deleted = 0;
	
	// Fix bug where bots deleted by old delete_bots script were not removed from the user group table
	$group_id = check_bot_group();
	$sql = 'DELETE FROM ' . USER_GROUP_TABLE . ' WHERE group_id = ' . $group_id . ' AND user_id NOT IN (SELECT user_id FROM ' . USERS_TABLE . ')';
	$db->sql_query($sql);
	
	// Fix bug where bots had spaces for user agent and IP addresses instead of null strings
	$sql = 'UPDATE ' . BOTS_TABLE . " SET bot_ip = '' WHERE bot_ip = ' '";
	$db->sql_query($sql);
	$sql = 'UPDATE ' . BOTS_TABLE . " SET bot_agent = '' WHERE bot_agent = ' '";
	$db->sql_query($sql);
	
	// Update or remove bots as necessary
	foreach ($bots as $bot_name => $bot_ary)  
	{
		$bots_checked++;
		
		// Check if bot is there
		$user_id = bot_defined($bot_name, false);
		if (!$user_id) continue;

		// Initialize bot update variables
		// NOTE:  Both flags are needed becauase if a bot has already been updated, we don't want to end up deleting it!		
		$bot_updated = false;
		$bot_delete = true;
		
if ($debug_level & 4) echo 'Before agent update checking, bot delete flag = ' . $bot_delete . '<br />';
		
		// Get the current bot info
		$sql = 'SELECT bot_active, bot_agent, bot_ip FROM ' . BOTS_TABLE . ' WHERE user_id = ' . $user_id;
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$bot_active = (int) $row['bot_active'];  
		$bot_agent = $row['bot_agent'];  
		$bot_ip = $row['bot_ip'];  
		$db->sql_freeresult($result);
		
		// Get the updated bot information
		$bot_new_name = $bot_ary[$gc_updt_idx_name];
		$bot_new_agent = $bot_ary[$gc_updt_idx_agent];
		$bot_new_ip = $bot_ary[$gc_updt_idx_ip];
		$bot_new_active = (int) $bot_ary[$gc_updt_idx_active];

		// Update Bots table with new bot agent
		if ($bot_new_agent <> '')
		{
			$bot_delete = false;
			
			similar_bots($bot_name, $bot_new_agent, '');
			
			if ($bot_new_agent <> $bot_agent)
			{
				$sql = 'UPDATE ' . BOTS_TABLE . " SET bot_agent = '" . $bot_new_agent . "' WHERE user_id = " . $user_id;
				$db->sql_query($sql);
				
				$bot_updated = true;
			} // if ($bot_new_agent <> $bot_agent)
		} // if ($bot_new_agent <> '')
		
if ($debug_level & 4) echo 'Before IP address update checking, bot delete flag = ' . $bot_delete . '<br />';
				
		// Update Bots table with new bot IP address
		if ($bot_new_ip <> '')
		{
			$bot_delete = false;
			similar_bots($bot_name, '', $bot_new_ip);

			if ($bot_new_ip <> $bot_ip)
			{
				$sql = 'UPDATE ' . BOTS_TABLE . " SET bot_ip = '" . $bot_new_ip . "' WHERE user_id = " . $user_id;
				$db->sql_query($sql);
			
				$bot_updated = true;
			} // if ($bot_new_ip <> $bot_ip)
		} // if ($bot_new_ip <> '')
		
if ($debug_level & 4) echo 'Before activation checking, bot delete flag = ' . $bot_delete . '<br />';

		// Update Bots table with new bot activation status
		if ($bot_new_active >= 0)
		{
			$bot_delete = false;
	
			if ($bot_new_active <> $bot_active)
			{
				$sql = 'UPDATE ' . BOTS_TABLE . ' SET bot_active = ' . $bot_new_active . ' WHERE user_id = ' . $user_id;
				$db->sql_query($sql);
			
				$bot_updated = true;
			} // if ($bot_new_active <> $bot_active)
		} // if ($bot_new_active >= 0)
		
if ($debug_level & 4) echo 'Before last visit checking, bot delete flag = ' . $bot_delete . '<br />';

		// Get the current bot user information
		$sql = 'SELECT user_lastvisit, user_email FROM ' . USERS_TABLE . ' WHERE user_id = ' . $user_id;  
		$user_result = $db->sql_query($sql);
		$user_row = $db->sql_fetchrow($user_result);
		$user_visit = (int) $user_row['user_lastvisit'];  
		$user_email = $user_row['user_email'];  
		//$user_website = $user_row['user_website'];  
		$db->sql_freeresult($user_result);

		// Get the updated bot user information
		$user_new_visit = $bot_ary[$gc_updt_idx_visit];
		$user_new_email = $bot_ary[$gc_updt_idx_email];
		$user_new_website = $bot_ary[$gc_updt_idx_website];

		// Update User table with new bot last visit time
		if ($user_new_visit >= 0)
		{
			$bot_delete = false;
	
			if ($user_new_visit <> $user_visit)
			{
				$sql = 'UPDATE ' . BOTS_TABLE . ' SET user_visit = ' . $user_new_visit . ' WHERE user_id = ' . $user_id;
				$db->sql_query($sql);
			
				$bot_updated = true;
			} // if ($user_new_visit <> $user_visit)
		} // if ($user_new_visit >= 0)
		
if ($debug_level & 4) echo 'Before E-mail update checking, bot delete flag = ' . $bot_delete . '<br />';

		// Update Users table with new bot E-mail address
		if ($user_new_email <> '')
		{
			$bot_delete = false;
//	Do not call similar_bots for E-mail address; multiple bots can have the same E-mail address

			if ($user_new_email <> $user_email)
			{
				$sql = 'UPDATE ' . USERS_TABLE . " SET user_email = '" . $user_new_email . "' WHERE user_id = " . $user_id;
				$db->sql_query($sql);
			
				$bot_updated = true;
			} // ($user_new_email <> $user_email)
		} // if ($user_new_email <> '')
		
if ($debug_level & 4) echo 'Before Web update checking, bot delete flag = ' . $bot_delete . '<br />';

		// Update Users table with new bot Web address
		if ($user_new_website <> '')
		{
			$bot_delete = false;
//	Do not call similar_bots for Web site; multiple bots can have the same Web site
 // ($user_new_website <> $user_website)
		} // if ($user_new_website <> '')
		
if ($debug_level & 4) echo 'Before name update checking, bot delete flag = ' . $bot_delete . '<br />';

		// Update User and Bots tables with new bot name
		// NOTE:  This must be done LAST to ensure agent and IP changes work
		if ($bot_new_name <> '')
		{
			$bot_delete = false;

			// Ensure the new name doesn't already exist
			if (!bot_defined($bot_new_name, true))
			{
				// Update the bot's name
				$sql_ary['username'] = $bot_new_name;
				$sql_ary['username_clean'] = (string) utf8_clean_string($bot_new_name);
	
				$sql = 'UPDATE ' . USERS_TABLE . ' SET ' . $db->sql_build_array('UPDATE', $sql_ary) . ' WHERE user_id = ' . $user_id;
				$db->sql_query($sql);
				
				$sql = 'UPDATE ' . BOTS_TABLE . " SET bot_name = '" . $bot_new_name . "' WHERE user_id = " . $user_id;
				$db->sql_query($sql);
				
				// Updates user names in other tables; probably not relevant to bots, but we'll play it safe
				user_update_name($bot_name, $bot_new_name);
				
				$bot_updated = true;
			} else {
				printf($mbots_lang['MBOTS_ALREADY_EXISTS'], $bot_new_name, $bot_name);
			} // if (!bot_defined($bot_new_name, true)) ... else ...
		} // if ($bot_new_name <> '')
		
if ($debug_level & 4) echo 'After all update checking, bot delete flag = ' . $bot_delete . '<br />';

		// If the bot was updated, increment the update count; otherwise delete the bot
		if ($bot_updated)
		{
			printf($mbots_lang['MBOTS_UPDATED_BOT'], ($bot_new_name == '' ? $bot_name : $bot_new_name));
			$bots_updated++;
		} else if ($bot_delete) {
			remove_bot($user_id);
			printf($mbots_lang['MBOTS_DELETED_OLD_BOT'], $bot_name);
			$bots_deleted++;
		} // if ($bot_updated) ... else if ($bot_delete)
	} // foreach ($bots as $bot_name => $bot_ary)

	// Output list of conflicting bots
if ($debug_level & 2) echo "In update_bots, conflicting bot list = " . $g_conflicting_bots . "<br />";
  list_conflicting_bots($g_conflicting_bots, '');

	// If changes made, clear the cache and write appropriate messages
	if ($bots_updated + $bots_deleted)
	{
		$cache->destroy('_bots');
		if ($bots_updated)
			{
				printf($mbots_lang['MBOTS_UPDATED_BOTS'], $bots_updated);
				$message = $mbots_lang['MBOTS_SCRIPT_PREFIX'] . sprintf($mbots_lang['MBOTS_UPDATED_LOG'], $bots_updated);
				add_log('admin', 'LOG_BOT_UPDATED', $message);
			} // if ($bots_updated)
		
		if ($bots_deleted)
			{
				printf($mbots_lang['MBOTS_DELETED_OLD_BOTS'], $bots_deleted);
				$message = $mbots_lang['MBOTS_SCRIPT_PREFIX'] . sprintf($mbots_lang['MBOTS_DELETED_OLD_LOG'], $bots_deleted);
				add_log('admin', 'LOG_BOT_DELETE', $message);
			} // if ($bots_deleted)
			
	} // if ($bots_updated + $bots_deleted)

if ($debug_level & 1) echo '<< Exiting update_bots<br />';
		
	return $bots_checked;
} // End update_bots function

//
// Check if a given bot is already in the database
//
function bot_defined($bot_name, $use_clean_name)
{
	global $db, $config;
	global $mbots_lang, $debug_level;
	
	if ($use_clean_name)
	{
		$sql = 'SELECT user_id FROM ' . USERS_TABLE . " WHERE username_clean = '" . $db->sql_escape(utf8_clean_string($bot_name)) . "'";  
	} else {
		$sql = 'SELECT user_id FROM ' . USERS_TABLE . " WHERE username = '" . $db->sql_escape($bot_name) . "'";  
	} // if ($use_clean_name)
	
	$result = $db->sql_query($sql);
	$user_id = (int) $db->sql_fetchfield('user_id', false, $result);  
	$db->sql_freeresult($result);

  if ($user_id)
  {
		if ($debug_level & 4) echo 'Bot ' . $bot_name . ' has user id = ' . $user_id . '<br /><br />';
	} else {
		if ($debug_level & 4) echo 'Bot ' . $bot_name . ' does not exist in database<br /><br />';
	}
		
	return $user_id;
} // End bot_defined function

//
// Check for bots in database with similar names, agents or IP addreesses
//
function conflicting_bots()
{
	global $db, $config;
	global $g_conflicting_bots;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering conflicting_bots<br />';

	$sql = 'SELECT bot_name, bot_agent, bot_ip FROM ' . BOTS_TABLE . ' WHERE 1 ORDER BY bot_name';
	$result = $db->sql_query($sql); 

	while ($row = $db->sql_fetchrow($result))
	{
		$bot_name = $row['bot_name'];
		$bot_agent = $row['bot_agent'];
		$bot_ip = $row['bot_ip'];
		similar_bots($bot_name, $bot_agent, $bot_ip);
	} // while ($row = $db->sql_fetchrow($result))

	$db->sql_freeresult($result);

  list_conflicting_bots($g_conflicting_bots, $mbots_lang['MBOTS_NO_CONFLICTING_BOTS']);

if ($debug_level & 1) echo '<< Exiting conflicting_bots<br />';

} // End conflicting_bots function

//
// Look for bots with similar names, agents or IP addreesses
//
function similar_bots($bot_name, $bot_agent, $bot_ip)
{
	global $db, $config;
	global $g_conflicting_bots;
	global $mbots_lang, $debug_level;

if ($debug_level & 2) echo '>> Entering similar_bots<br />';
if ($debug_level & 4) echo $bot_name . " agent = '" . $bot_agent . "', IP address = '" . $bot_ip . "'<br />";

  // Find if there are any similar bot agents
	if (trim($bot_agent) <> '')
	{
		$sql = 'SELECT bot_name, bot_agent' .  
		       ' FROM ' . BOTS_TABLE . 
		       ' WHERE (bot_agent LIKE ' . "'%" . $bot_agent . "%')";
if ($debug_level & 4) echo 'Agent SQL  ' . $sql . '<br />';
		$result = $db->sql_query($sql); 
		while ($row = $db->sql_fetchrow($result))
		{
			$bot_match = $row['bot_name'];
			$agent_match = $row['bot_agent'];
			if ($bot_match <> $bot_name)
			{
if ($debug_level & 4) echo $bot_match . ' agent = ' . $agent_match . '<br />';
				printf($mbots_lang['MBOTS_AGENT_CONFLICT'], $bot_name, $bot_agent, $bot_match, $agent_match);
				$g_conflicting_bots = ($g_conflicting_bots) ? ($g_conflicting_bots . ', ' . $bot_name) : $bot_name;
			} // if ($bot_match <> $bot_name)
		} // while ($row = $db->sql_fetchrow($result))
		$db->sql_freeresult($result);
	} // if ($bot_agent <> '')

	// Find if there are any similar bot IP addresses
	if (trim($bot_ip) <> '')
	{
		$sql = 'SELECT bot_name, bot_ip FROM ' . BOTS_TABLE . ' WHERE bot_ip = ' . "'" . $bot_ip . "'";
		$result = $db->sql_query($sql); 
		while ($row = $db->sql_fetchrow($result))
		{
			$bot_match = $row['bot_name'];
			$ip_match = $row['bot_ip'];
if ($debug_level & 4) echo $bot_match . ' IP address = ' . $bot_ip . '<br />';
			if ($bot_match <> $bot_name)
			{
				printf($mbots_lang['MBOTS_IP_CONFLICT'], $bot_name, $bot_ip, $bot_match, $ip_match);
				$g_conflicting_bots = ($g_conflicting_bots) ? ($g_conflicting_bots . ', ' . $bot_name) : $bot_name;
			} // if ($bot_match <> $bot_name)
		} // while ($row = $db->sql_fetchrow($result))
		$db->sql_freeresult($result);
	} // if ($bot_ip <> '')
	
if ($debug_level & 2) echo "Conflicting bot list = " . $g_conflicting_bots . "<br />";

if ($debug_level & 2) echo '<< Exiting similar_bots<br />';

} // End similar_bots function

//
// Output list of conflicting bots
//
function list_conflicting_bots($conflicting_bots, $message_none)
{
	global $mbots_lang, $debug_level;

if ($debug_level & 2) echo '>> Entering list_conflicting_bots<br />';

	// If no conflicting bots, check if we should write message
	if (!$conflicting_bots)
	{
		if ($message_none) echo $message_none;
		return;
	} // if (!$conflicting_bots)

	printf($mbots_lang['MBOTS_CONFLICTING_BOTS'], $conflicting_bots);

if ($debug_level & 2) echo '<< Exiting list_conflicting_bots<br />';

	return;
	
} // End list_conflicting_bots function

//
// Display script help
//
function display_help()
{
	global $gc_credit_idx_name, $gc_credit_idx_phpbb_url, $gc_credit_idx_visbots, $gc_credit_idx_nonvisbots, 
         $gc_credit_idx_special;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering display_help<br />';

	printf($mbots_lang['MBOTS_HELP_HEADER']);
	printf($mbots_lang['MBOTS_HELP_SYNTAX']);
	printf($mbots_lang['MBOTS_HELP_ADD'], $mbots_lang['MBOTS_OPERATION_ADD'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $mbots_lang['MBOTS_PARAMETER_LISTALL'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_DELETE'], $mbots_lang['MBOTS_OPERATION_DELETE'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_DEACTIVATE'], $mbots_lang['MBOTS_OPERATION_DEACTIVATE'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_ACTIVATE'], $mbots_lang['MBOTS_OPERATION_ACTIVATE'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_LIST'], $mbots_lang['MBOTS_OPERATION_LIST'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_LEVEL'], $mbots_lang['MBOTS_PARAMETER_LISTALL'], $mbots_lang['MBOTS_PARAMETER_FORMAT'], $mbots_lang['MBOTS_PARAMETER_NUMBER'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_UPDATE'], $mbots_lang['MBOTS_OPERATION_UPDATE'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_CONFLICTS'], $mbots_lang['MBOTS_OPERATION_CONFLICTS'], $mbots_lang['MBOTS_PARAMETER_OPERATION'], $mbots_lang['MBOTS_PARAMETER_PASSWORD']);
	printf($mbots_lang['MBOTS_HELP_HELP'], $mbots_lang['MBOTS_OPERATION_HELP'], $mbots_lang['MBOTS_PARAMETER_OPERATION']);
	display_donation();
	printf($mbots_lang['MBOTS_HELP_SUPPORT']);
	display_credits();
	printf($mbots_lang['MBOTS_HELP_FOOTER']);

if ($debug_level & 1) echo '<< Exiting display_help<br />';
	return;
} // End display_help function

//
// Display donation information
//
function display_donation()
{
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering display_donation<br />';

	printf($mbots_lang['MBOTS_HELP_DONATE']);

if ($debug_level & 1) echo '<< Exiting display_donation<br />';
	return;
} // End display_dontation function

//
// Display script credits
//
function display_credits()
{
	global $mbots_credits;
	global $gc_credit_idx_name, $gc_credit_idx_phpbb_url, $gc_credit_idx_visbots, $gc_credit_idx_nonvisbots, 
         $gc_credit_idx_special, $gc_credit_idx_sort_order;
	global $mbots_lang, $debug_level;

if ($debug_level & 1) echo '>> Entering display_credits<br />';

	// Sort the credit array
  uasort($mbots_credits, 'credit_sort');

	// Display the table title and header
	printf($mbots_lang['MBOTS_HELP_CREDITS']);

	echo '<table border="1">';

	echo '<tr>';
	echo '<th align="left">';
	printf($mbots_lang['MBOTS_HELP_CREDITS_HEADER_RANK']);
	echo '</th>';
	echo '<th align="left">';
	printf($mbots_lang['MBOTS_HELP_CREDITS_HEADER_NAME']);
	echo '</th>';
	echo '<th align="left">';
	printf($mbots_lang['MBOTS_HELP_CREDITS_HEADER_VISITING_BOTS']);
	echo '</th>';
	echo '<th align="left">';
	printf($mbots_lang['MBOTS_HELP_CREDITS_HEADER_NON-VISITING_BOTS']);
	echo '</th>';
	echo '<th align="left">';
	printf($mbots_lang['MBOTS_HELP_CREDITS_HEADER_SPECIAL']);
	echo '</th>';
	echo '</tr>';
	
	// Display each credit
	
	$fmt_start_text = "<td style='text-align: left; vertical-align: top;'>";
  $fmt_start_num = "<td style='text-align: right; vertical-align: top;'>";
  $fmt_end = "</td>";
  $rank = 0;

	foreach ($mbots_credits as $cred_level => $credits_ary)  
	{
		echo '<tr>';
		
		$rank++;
		$user = $credits_ary[$gc_credit_idx_name];
		$profile_url = $credits_ary[$gc_credit_idx_phpbb_url];
		$vbots = $credits_ary[$gc_credit_idx_visbots];
		$nvbots = $credits_ary[$gc_credit_idx_nonvisbots];
		$special = $credits_ary[$gc_credit_idx_special];
		$order = $credits_ary[$gc_credit_idx_sort_order];

		// Write the rank with handling of non-ranked items (nvbots < 0 or vbots and nvbots = 0)
		echo $fmt_start_num;
		if ((($vbots > 0) && ($nvbots >= 0)) || ($nvbots > 0))
		{ 
			echo $rank;
		} else {
			echo $mbots_lang['MBOTS_NOT_APPLICABLE'];
		} // if ((($vbots > 0) && ($nvbots >= 0)) || ($nvbots > 0)) ... else ...
		echo $fmt_end;
		
		// Write user name (possibly as a link)
		if ($profile_url != '')
		{
			$user = '<a href="' . $profile_url . '">' . $user . '</a>';
		} // if (!$profile_url)
		
		echo $fmt_start_text . $user . $fmt_end;

		// Write visting bots count
		echo $fmt_start_num . $vbots . $fmt_end;

		// Write non-visting bots count
		echo $fmt_start_num;
		if ($nvbots <> -1)
		{ 
			echo $nvbots;
		} else {
			echo $mbots_lang['MBOTS_NOT_APPLICABLE'];
		} // if ($nvbots <> -1) ... else ...
		echo $fmt_end;
	
		// Write special credits
		echo $fmt_start_text;
		if  ($special != '')
		{
			echo $mbots_lang[$special];
		} else {
			echo '&nbsp;';
		} // if  ($special)
		echo $fmt_end;
		echo '</tr>';
	} // foreach ($mbots_credits as $cred_level => $credits_ary)
	
	echo '</table>';	

if ($debug_level & 1) echo '<< Exiting display_credits<br />';
	return;
} // End display_credits function

//
// Return sorted elements for credits
//
function credit_sort($a, $b)
{
	global $gc_credit_idx_name, $gc_credit_idx_phpbb_url, $gc_credit_idx_visbots, $gc_credit_idx_nonvisbots, 
         $gc_credit_idx_special, $gc_credit_idx_sort_order;
	global $debug_level;
	
	// Handle special case where non-visiting bots count < 0 for only one item
	// Because we want a DESCENDING sort by counts, reverse the usual 1/-1 values
	
	if ($a[$gc_credit_idx_nonvisbots] < 0)
	{
		if (($b[$gc_credit_idx_visbots] == 0) && ($b[$gc_credit_idx_nonvisbots] == 0)) return -1;
		else if ($b[$gc_credit_idx_nonvisbots] >= 0) return 1;
	} // if ($a[$gc_credit_idx_nonvisbots] < 0)

	if ($b[$gc_credit_idx_nonvisbots] < 0) 
	{
		if (($a[$gc_credit_idx_visbots] == 0) && ($a[$gc_credit_idx_nonvisbots] == 0)) return 1;
		else if ($a[$gc_credit_idx_nonvisbots] >= 0) return -1;
	} // if ($b[$gc_credit_idx_nonvisbots] < 0)
	
	// Check which item's visiting bots count is greater
	// Because we want a DESCENDING sort by counts, reverse the usual 1/-1 values 
	
	if ($a[$gc_credit_idx_visbots] > $b[$gc_credit_idx_visbots]) return -1;
	if ($a[$gc_credit_idx_visbots] < $b[$gc_credit_idx_visbots]) return 1;
	
	// If visiting bots counts are equal, check which item's non-visiting bots count is greater
	// Because we want a DESCENDING sort by counts, reverse the usual 1/-1 values 
	
	if ($a[$gc_credit_idx_nonvisbots] > $b[$gc_credit_idx_nonvisbots]) return -1;
	if ($a[$gc_credit_idx_nonvisbots] < $b[$gc_credit_idx_nonvisbots]) return 1;
	
	// If both bots counts are equal, check if only one has special credit information
	// Because we want a DESCENDING sort by counts, reverse the usual 1/-1 values 
	
	if (($a[$gc_credit_idx_special] != '') && ($b[$gc_credit_idx_special] == '')) return -1;
	if (($a[$gc_credit_idx_special] == '') && ($b[$gc_credit_idx_special] != '')) return 1;

	// Everything is equal up to now, so return items based on their defined sort order (this makes the sort stable)
	if ($a[$gc_credit_idx_sort_order] == $b[$gc_credit_idx_sort_order]) return 0;  // Should never happen

	return ($a[$gc_credit_idx_sort_order] > $b[$gc_credit_idx_sort_order] ? 1 : -1) ;
} // End credit_sort function

//
// Check the numeric values
//
function get_parameter($parm, $default)
{
	return request_var($parm, $default);
//	return (isset( $_GET[$parm] )? $_GET[$parm]: $default);
} // End get_parameter function

//
// Check the numeric values
//
function check_number($str, $max)
{
	if ((strlen($str) <> strspn($str, '0123456789')) || ($str < 0)) return -1;
	$temp = intval($str);
	return ((($max < 0) || ($temp <= $max)) ? $temp : -1);
} // End check_number function

//
// Check the user's password
//
function check_password($username, $password)
{
	global $config, $db, $user, $phpbb_root_path, $phpEx;
	global $mbots_lang, $debug_level;

	$method = trim(basename($config['auth_method']));
	include_once($phpbb_root_path . 'includes/auth/auth_' . $method . '.' . $phpEx);

	$method = 'login_' . $method;
	if (function_exists($method))
	{
		$login = $method($username, $password);

		if (($login['status'] == LOGIN_SUCCESS_CREATE_PROFILE) || ($login['status'] == LOGIN_SUCCESS))
		{
			return true;
		} else {
			return false;
		} // if (($login['status'] == LOGIN_SUCCESS_CREATE_PROFILE)) || ($login['status'] == LOGIN_SUCCESS)) ... else ...
	} else {
		trigger_error('Authentication method not found', E_USER_ERROR);
	} // if (function_exists($method)) ... else ...

} // End check_password function

?>